/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphWriter;

import ai.stapi.graph.Graph;
import ai.stapi.graph.attribute.attributeFactory.GenericAttributeFactory;
import ai.stapi.graph.graphElementForRemoval.GraphElementForRemoval;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.GraphDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.PositiveGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.removal.RemovalGraphDescription;
import ai.stapi.graphoperations.graphWriter.SpecificGraphWriter;
import ai.stapi.graphoperations.graphWriter.exceptions.GenericGraphWriterException;
import ai.stapi.graphoperations.graphbuilder.GraphBuilder;
import ai.stapi.identity.UniqueIdentifier;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class GenericGraphWriter {
    private final List<SpecificGraphWriter> specificGraphWriters;
    private final GenericAttributeFactory genericAttributeFactory;

    public GenericGraphWriter(List<SpecificGraphWriter> specificGraphWriters, GenericAttributeFactory genericAttributeFactory) {
        this.specificGraphWriters = specificGraphWriters;
        this.genericAttributeFactory = genericAttributeFactory;
    }

    public Graph createGraph(UniqueIdentifier firstElementId, PositiveGraphDescription graphDescription) {
        if (!(graphDescription instanceof NodeDescription)) {
            throw GenericGraphWriterException.becauseFirstDescriptionHasToBeNode(graphDescription);
        }
        this.ensureGraphDescriptionContainsOnlyPositiveDescriptions(graphDescription);
        GraphBuilder builder = this.resolvePositiveDescription(graphDescription, new GraphBuilder());
        builder.getFirstGraphElement().setId(firstElementId);
        builder.dropIncompleteEdges();
        return builder.build(this.genericAttributeFactory);
    }

    public Graph createGraph(PositiveGraphDescription graphDescription) {
        if (!(graphDescription instanceof NodeDescription)) {
            throw GenericGraphWriterException.becauseFirstDescriptionHasToBeNode(graphDescription);
        }
        this.ensureGraphDescriptionContainsOnlyPositiveDescriptions(graphDescription);
        GraphBuilder builder = this.resolvePositiveDescription(graphDescription, new GraphBuilder());
        builder.dropIncompleteEdges();
        return builder.build(this.genericAttributeFactory);
    }

    public List<GraphElementForRemoval> createElementsForRemoval(List<RemovalGraphDescription> removalGraphDescriptions) {
        GraphBuilder builder = new GraphBuilder();
        removalGraphDescriptions.forEach(description -> {
            SpecificGraphWriter resolver = this.getSupportingGraphWriter((GraphDescription)description);
            resolver.write((GraphDescription)description, builder);
        });
        return builder.buildElementsForRemoval();
    }

    private GraphBuilder resolvePositiveDescription(PositiveGraphDescription graphDescription, GraphBuilder graphBuilder) {
        SpecificGraphWriter supportingWriter = this.getSupportingGraphWriter(graphDescription);
        supportingWriter.write(graphDescription, graphBuilder);
        graphDescription.getChildGraphDescriptions().forEach(child -> {
            GraphBuilder newBranch = graphBuilder.createNewBranch();
            this.resolvePositiveDescription((PositiveGraphDescription)child, newBranch);
        });
        return graphBuilder;
    }

    private GraphBuilder resolveRemovalDescription(GraphDescription graphDescription, GraphBuilder graphBuilder) {
        SpecificGraphWriter supportingWriter = this.getSupportingGraphWriter(graphDescription);
        supportingWriter.write(graphDescription, graphBuilder);
        graphDescription.getChildGraphDescriptions().forEach(child -> {
            GraphBuilder newBranch = graphBuilder.createNewBranch();
            this.resolveRemovalDescription((GraphDescription)child, newBranch);
        });
        return graphBuilder;
    }

    private void ensureGraphDescriptionContainsOnlyPositiveDescriptions(PositiveGraphDescription graphDescription) {
        Optional<GraphDescription> removalDescription = GraphDescriptionBuilder.getGraphDescriptionAsStream(graphDescription).filter(RemovalGraphDescription.class::isInstance).findAny();
        removalDescription.ifPresent(description -> {
            throw GenericGraphWriterException.becauseGraphDescriptionContainsRemovalGraphDescription(description);
        });
    }

    @NotNull
    private SpecificGraphWriter getSupportingGraphWriter(GraphDescription graphDescription) {
        Stream<SpecificGraphWriter> supportingGraphWriters = this.specificGraphWriters.stream().filter(specificGraphWriter -> specificGraphWriter.supports(graphDescription));
        List<SpecificGraphWriter> listOfSupportingResolvers = supportingGraphWriters.toList();
        if (listOfSupportingResolvers.isEmpty()) {
            throw GenericGraphWriterException.becauseNoSupportingSpecificResolverForGivenDeclaration(graphDescription);
        }
        if (listOfSupportingResolvers.size() > 1) {
            throw GenericGraphWriterException.becauseMoreThanOneSpecificResolverForGivenDeclaration(graphDescription, listOfSupportingResolvers);
        }
        return listOfSupportingResolvers.get(0);
    }
}

