/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.serializableGraph;

import ai.stapi.graph.attribute.Attribute;
import ai.stapi.graph.attribute.LeafAttribute;
import ai.stapi.graph.attribute.ListAttribute;
import ai.stapi.graph.attribute.SetAttribute;
import ai.stapi.graphoperations.serializableGraph.SerializableAttributeValue;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SerializableAttributeVersion {
    private final List<SerializableAttributeValue> values;
    private final Map<String, List<SerializableAttributeValue>> metaData;

    public static SerializableAttributeVersion fromAttribute(Attribute<?> attribute) {
        HashMap<String, List<SerializableAttributeValue>> metaData = new HashMap<String, List<SerializableAttributeValue>>();
        attribute.getMetaData().forEach((name, meta) -> metaData.put((String)name, meta.getValues().stream().map(SerializableAttributeValue::new).toList()));
        if (attribute instanceof LeafAttribute) {
            LeafAttribute leafAttribute = (LeafAttribute)attribute;
            return new SerializableAttributeVersion(List.of(new SerializableAttributeValue(leafAttribute.getBoxedValue())), metaData);
        }
        if (attribute instanceof ListAttribute) {
            ListAttribute listAttribute = (ListAttribute)attribute;
            return new SerializableAttributeVersion(listAttribute.getBoxedValues().stream().map(SerializableAttributeValue::new).toList(), metaData);
        }
        if (attribute instanceof SetAttribute) {
            SetAttribute setAttribute = (SetAttribute)attribute;
            return new SerializableAttributeVersion(setAttribute.getBoxedValues().stream().map(SerializableAttributeValue::new).toList(), metaData);
        }
        return new SerializableAttributeVersion(List.of(), Map.of());
    }

    @JsonCreator
    public SerializableAttributeVersion(@JsonProperty(value="values") List<SerializableAttributeValue> values, @JsonProperty(value="metaData") Map<String, List<SerializableAttributeValue>> metaData) {
        this.values = values;
        this.metaData = metaData;
    }

    public List<SerializableAttributeValue> getValues() {
        return this.values;
    }

    public Map<String, List<SerializableAttributeValue>> getMetaData() {
        return this.metaData;
    }
}

