/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.serializableGraph;

import ai.stapi.graph.Graph;
import ai.stapi.graphoperations.serializableGraph.SerializableEdge;
import ai.stapi.graphoperations.serializableGraph.SerializableNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public class SerializableGraph {
    private final Map<String, SerializableNode> nodes;
    private final Map<String, SerializableEdge> edges;

    public static SerializableGraph fromInMemory(Graph graph) {
        HashMap<String, SerializableNode> nodes = new HashMap<String, SerializableNode>();
        graph.getAllNodes().stream().map(SerializableNode::fromInputNode).forEach(node -> nodes.put(node.getGlobalId(), (SerializableNode)node));
        HashMap<String, SerializableEdge> edges = new HashMap<String, SerializableEdge>();
        graph.getAllEdges().stream().map(SerializableEdge::fromInputEdge).forEach(edge -> edges.put(edge.getGlobalId(), (SerializableEdge)edge));
        return new SerializableGraph(nodes, edges);
    }

    @JsonCreator
    public SerializableGraph(@JsonProperty(value="nodes") Map<String, SerializableNode> nodes, @JsonProperty(value="edges") Map<String, SerializableEdge> edges) {
        this.nodes = nodes;
        this.edges = edges;
    }

    public Map<String, SerializableNode> getNodes() {
        return this.nodes;
    }

    public Map<String, SerializableEdge> getEdges() {
        return this.edges;
    }
}

