/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.serializableGraph.deserializer;

import ai.stapi.graph.attribute.MetaData;
import ai.stapi.graph.attribute.attributeFactory.AttributeValueFactoryInput;
import ai.stapi.graph.attribute.attributeFactory.GenericAttributeFactory;
import ai.stapi.graph.attribute.attributeFactory.attributeValueFactory.GenericAttributeValueFactory;
import ai.stapi.graph.versionedAttributes.ImmutableVersionedAttribute;
import ai.stapi.graph.versionedAttributes.ImmutableVersionedAttributeGroup;
import ai.stapi.graph.versionedAttributes.VersionedAttribute;
import ai.stapi.graphoperations.serializableGraph.SerializableAttributeValue;
import ai.stapi.graphoperations.serializableGraph.SerializableAttributeVersion;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SerializableAttributeDeserializer {
    private final StructureSchemaFinder structureSchemaFinder;
    private final GenericAttributeFactory genericAttributeFactory;
    private final GenericAttributeValueFactory genericAttributeValueFactory;

    public SerializableAttributeDeserializer(StructureSchemaFinder structureSchemaFinder, GenericAttributeFactory genericAttributeFactory, GenericAttributeValueFactory genericAttributeValueFactory) {
        this.structureSchemaFinder = structureSchemaFinder;
        this.genericAttributeFactory = genericAttributeFactory;
        this.genericAttributeValueFactory = genericAttributeValueFactory;
    }

    public VersionedAttribute<?> deserialize(String graphElementType, String attributeName, List<SerializableAttributeVersion> attribute) {
        FieldDefinition fieldDefinition = this.structureSchemaFinder.getFieldDefinitionOrFallback(graphElementType, attributeName);
        return new ImmutableVersionedAttribute(attribute.stream().map(serializableAttributeVersion -> {
            HashMap metaData = new HashMap();
            serializableAttributeVersion.getMetaData().forEach((name, meta) -> metaData.put(name, new MetaData(name, meta.stream().map(value -> this.genericAttributeValueFactory.create(name, new AttributeValueFactoryInput(value.getValue(), value.getSerializationType()))).collect(Collectors.toList()))));
            return this.genericAttributeFactory.create(attributeName, this.getStructureType(fieldDefinition), serializableAttributeVersion.getValues().stream().map(SerializableAttributeValue::toAttributeFactoryInput).toList(), metaData);
        }).toList());
    }

    public ImmutableVersionedAttributeGroup deserializeGroup(String graphElementType, Map<String, List<SerializableAttributeVersion>> attributeMap) {
        HashMap rawMap = new HashMap();
        attributeMap.forEach((attributeName, attribute) -> rawMap.put(attributeName, this.deserialize(graphElementType, (String)attributeName, (List<SerializableAttributeVersion>)attribute)));
        return new ImmutableVersionedAttributeGroup(rawMap);
    }

    @NotNull
    private String getStructureType(FieldDefinition fieldDefinition) {
        return fieldDefinition.getStructureType().equals("leaf") ? "LeafAttribute" : "ListAttribute";
    }
}

