/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphLoader.inmemory;

import ai.stapi.graph.AttributeContainer;
import ai.stapi.graph.Graph;
import ai.stapi.graph.attribute.Attribute;
import ai.stapi.graph.attribute.LeafAttribute;
import ai.stapi.graph.attribute.attributeValue.AttributeValue;
import ai.stapi.graph.attribute.attributeValue.IdAttributeValue;
import ai.stapi.graph.graphelements.Edge;
import ai.stapi.graph.graphelements.Node;
import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.graph.traversableGraphElements.TraversableGraphElement;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graph.versionedAttributes.VersionedAttribute;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractAttributeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractEdgeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractNodeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AllAttributesDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AttributeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.EdgeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.PositiveGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.UuidIdentityDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.EdgeQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.GraphElementQueryDescription;
import ai.stapi.graphoperations.graphLoader.GraphLoader;
import ai.stapi.graphoperations.graphLoader.GraphLoaderFindAsObjectOutput;
import ai.stapi.graphoperations.graphLoader.GraphLoaderGetAsObjectOutput;
import ai.stapi.graphoperations.graphLoader.GraphLoaderReturnType;
import ai.stapi.graphoperations.graphLoader.exceptions.GraphLoaderException;
import ai.stapi.graphoperations.graphLoader.inmemory.InMemoryGenericSearchOptionResolver;
import ai.stapi.graphoperations.graphLoader.inmemory.InMemorySearchResolvingContext;
import ai.stapi.graphoperations.graphLoader.search.SearchOption;
import ai.stapi.graphoperations.graphLoader.search.SearchQueryParameters;
import ai.stapi.graphoperations.graphLoader.search.filterOption.FilterOption;
import ai.stapi.graphoperations.graphLoader.search.paginationOption.PaginationOption;
import ai.stapi.graphoperations.graphLoader.search.sortOption.SortOption;
import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class InMemoryGraphLoader
implements GraphLoader {
    private final InMemoryGraphRepository inMemoryGraphRepository;
    private final InMemoryGenericSearchOptionResolver searchOptionResolver;
    private final StructureSchemaFinder structureSchemaFinder;
    private final ObjectMapper objectMapper;

    public InMemoryGraphLoader(InMemoryGraphRepository inMemoryGraphRepository, InMemoryGenericSearchOptionResolver searchOptionResolver, StructureSchemaFinder structureSchemaFinder, ObjectMapper objectMapper) {
        this.inMemoryGraphRepository = inMemoryGraphRepository;
        this.searchOptionResolver = searchOptionResolver;
        this.structureSchemaFinder = structureSchemaFinder;
        this.objectMapper = objectMapper;
    }

    public InMemoryGraphLoader(Graph graph, InMemoryGenericSearchOptionResolver searchOptionResolver, StructureSchemaFinder structureSchemaFinder, ObjectMapper objectMapper) {
        this.inMemoryGraphRepository = new InMemoryGraphRepository(graph);
        this.searchOptionResolver = searchOptionResolver;
        this.structureSchemaFinder = structureSchemaFinder;
        this.objectMapper = objectMapper;
    }

    @Override
    public List<TraversableGraphElement> findAsTraversable(GraphElementQueryDescription graphDescription) {
        GraphLoaderFindAsObjectOutput<Object> output = this.find(graphDescription, Object.class, GraphLoaderReturnType.GRAPH);
        return output.getGraphLoaderFindAsGraphOutput().getFoundGraphElementIds().stream().map(uuid -> output.getGraphLoaderFindAsGraphOutput().getGraph().loadGraphElement(uuid)).toList();
    }

    @Override
    public TraversableGraphElement getAsTraversable(UniqueIdentifier elementId, GraphElementQueryDescription graphDescription) {
        GraphLoaderGetAsObjectOutput<Object> graph = this.get(elementId, graphDescription, Object.class, GraphLoaderReturnType.GRAPH);
        return graph.getGraph().loadGraphElement(elementId);
    }

    @Override
    public <T> GraphLoaderFindAsObjectOutput<T> find(GraphElementQueryDescription graphElementQueryDescription, Class<T> objectClass, GraphLoaderReturnType ... returnTypes) {
        List<TraversableGraphElement> initialElements = this.getTraversableElements(graphElementQueryDescription);
        InMemoryGraphRepository graph = new InMemoryGraphRepository();
        ArrayList data = new ArrayList();
        initialElements.stream().map(element -> this.resolveStep((TraversableGraphElement)element, graphElementQueryDescription, this.convertReturnTypes(returnTypes))).forEach(stepOutput -> {
            graph.merge(stepOutput.getGraph());
            if (!stepOutput.getObject().isEmpty()) {
                data.add(this.objectMapper.convertValue(stepOutput.getObject(), objectClass));
            }
        });
        return new GraphLoaderFindAsObjectOutput(data, initialElements.stream().map(TraversableGraphElement::getId).toList(), graph);
    }

    private Set<GraphLoaderReturnType> convertReturnTypes(GraphLoaderReturnType[] returnTypes) {
        if (returnTypes.length == 0) {
            return Set.of(GraphLoaderReturnType.OBJECT);
        }
        return Arrays.stream(returnTypes).collect(Collectors.toSet());
    }

    @Override
    public <T> GraphLoaderGetAsObjectOutput<T> get(UniqueIdentifier elementId, GraphElementQueryDescription graphDescription, Class<T> objectClass, GraphLoaderReturnType ... returnTypes) {
        TraversableGraphElement element = this.getTraversableGraphElement(elementId, graphDescription);
        GraphLoaderStepOutput graphLoaderStepOutput = this.resolveStep(element, graphDescription, this.convertReturnTypes(returnTypes));
        return new GraphLoaderGetAsObjectOutput<Object>(this.objectMapper.convertValue(graphLoaderStepOutput.getObject(), objectClass), graphLoaderStepOutput.getGraph().traversable());
    }

    public Object getSearchOptionAttributeValue(UniqueIdentifier elementId, PositiveGraphDescription graphDescription) {
        TraversableGraphElement element = this.getTraversableGraphElement(elementId, graphDescription);
        return this.resolveSearchOptionStep(element, graphDescription);
    }

    @NotNull
    private TraversableGraphElement getTraversableGraphElement(UniqueIdentifier elementId, PositiveGraphDescription graphDescription) {
        GraphDescriptionParameters param;
        if (graphDescription instanceof AbstractNodeDescription && this.inMemoryGraphRepository.nodeExists(elementId, ((NodeDescriptionParameters)(param = (NodeDescriptionParameters)graphDescription.getParameters())).getNodeType())) {
            return this.inMemoryGraphRepository.loadNode(elementId, ((NodeDescriptionParameters)param).getNodeType());
        }
        if (graphDescription instanceof AbstractEdgeDescription && this.inMemoryGraphRepository.edgeExists(elementId, ((EdgeDescriptionParameters)(param = (EdgeDescriptionParameters)graphDescription.getParameters())).getEdgeType())) {
            return this.inMemoryGraphRepository.loadEdge(elementId, ((EdgeDescriptionParameters)param).getEdgeType());
        }
        throw GraphLoaderException.becauseThereIsNoGraphElementWithProvidedUuid(elementId, graphDescription);
    }

    private List<TraversableGraphElement> getTraversableElements(GraphElementQueryDescription graphDescription) {
        SearchQueryParameters searchQueryParameters = graphDescription.getSearchQueryParameters();
        if (graphDescription instanceof AbstractNodeDescription) {
            NodeDescriptionParameters params = (NodeDescriptionParameters)graphDescription.getParameters();
            List<TraversableGraphElement> traversableGraphElements = this.inMemoryGraphRepository.loadAllNodes(params.getNodeType()).stream().map(TraversableGraphElement.class::cast).toList();
            return this.applySearchQueryParameters(traversableGraphElements, searchQueryParameters, graphDescription);
        }
        if (graphDescription instanceof AbstractEdgeDescription) {
            EdgeDescriptionParameters params = (EdgeDescriptionParameters)graphDescription.getParameters();
            List<TraversableGraphElement> traversableGraphElements = this.inMemoryGraphRepository.loadAllEdges(params.getEdgeType()).stream().map(TraversableGraphElement.class::cast).toList();
            return this.applySearchQueryParameters(traversableGraphElements, searchQueryParameters, graphDescription);
        }
        throw new RuntimeException("There should never be any other graph descriptions");
    }

    private List<TraversableGraphElement> applySearchQueryParameters(List<TraversableGraphElement> traversableGraphElements, SearchQueryParameters searchQueryParameters, PositiveGraphDescription positiveGraphDescription) {
        InMemorySearchResolvingContext context = new InMemorySearchResolvingContext(traversableGraphElements.stream(), this.inMemoryGraphRepository, positiveGraphDescription);
        for (FilterOption<?> filter : searchQueryParameters.getFilterOptions()) {
            context = (InMemorySearchResolvingContext)this.searchOptionResolver.resolve(filter, context);
        }
        for (SortOption sort : searchQueryParameters.getSortOptions()) {
            context = (InMemorySearchResolvingContext)this.searchOptionResolver.resolve(sort, context);
        }
        context.applySort();
        PaginationOption<?> paginationOption = searchQueryParameters.getPaginationOption();
        if (paginationOption != null) {
            return ((InMemorySearchResolvingContext)this.searchOptionResolver.resolve(paginationOption, context)).getGraphElements();
        }
        return context.getGraphElements();
    }

    private GraphLoaderStepOutput resolveStep(TraversableGraphElement element, GraphDescription graphDescription, Set<GraphLoaderReturnType> returnTypes) {
        if (element instanceof TraversableNode) {
            TraversableNode node = (TraversableNode)element;
            return this.resolveTraversableNode(node, (AbstractNodeDescription)graphDescription, returnTypes);
        }
        if (element instanceof TraversableEdge) {
            TraversableEdge edge = (TraversableEdge)element;
            return this.resolveTraversableEdge(edge, (AbstractEdgeDescription)graphDescription, returnTypes);
        }
        throw new RuntimeException("There should never be any other graph element.");
    }

    private GraphLoaderStepOutput resolveTraversableNode(TraversableNode node, AbstractNodeDescription graphDescription, Set<GraphLoaderReturnType> returnTypes) {
        HashMap<String, Object> object = new HashMap<String, Object>();
        Graph graph = new Graph();
        List<Attribute<?>> attributes = this.resolveAttributes((AttributeContainer)node, graphDescription);
        if (returnTypes.contains((Object)GraphLoaderReturnType.GRAPH)) {
            Node inputNode = new Node(node.getId(), node.getType());
            for (Attribute attribute2 : attributes) {
                inputNode = inputNode.add(attribute2);
            }
            graph = graph.with(inputNode);
        }
        List<GraphDescription> childGraphDescriptions = graphDescription.getChildGraphDescriptions();
        if (returnTypes.contains((Object)GraphLoaderReturnType.OBJECT)) {
            if (childGraphDescriptions.stream().anyMatch(UuidIdentityDescription.class::isInstance)) {
                object.put("id", node.getId().getId());
            }
            attributes.forEach(attribute -> object.put(attribute.getName(), attribute.getValue()));
        }
        for (GraphDescription graphDescription2 : childGraphDescriptions) {
            EdgeQueryDescription edgeQueryDescription;
            SearchQueryParameters searchQueryParameters;
            if (!(graphDescription2 instanceof AbstractEdgeDescription)) continue;
            AbstractEdgeDescription edgeDescription = (AbstractEdgeDescription)graphDescription2;
            EdgeDescriptionParameters parameters = (EdgeDescriptionParameters)edgeDescription.getParameters();
            List edges = edgeDescription.isIngoing() ? node.getIngoingEdges(parameters.getEdgeType()) : node.getOutgoingEdges(parameters.getEdgeType());
            if (edgeDescription instanceof EdgeQueryDescription) {
                EdgeQueryDescription edgeQueryDescription2 = (EdgeQueryDescription)((Object)edgeDescription);
                searchQueryParameters = edgeQueryDescription2.getSearchQueryParameters();
            } else {
                searchQueryParameters = SearchQueryParameters.from(new SearchOption[0]);
            }
            ArrayList<TraversableGraphElement> graphElements = new ArrayList<TraversableGraphElement>(edges);
            List<TraversableGraphElement> filteredGraphElements = this.applySearchQueryParameters(graphElements, searchQueryParameters, edgeDescription);
            List<TraversableEdge> filteredEdges = filteredGraphElements.stream().map(TraversableEdge.class::cast).toList();
            FieldDefinition fieldSchema = this.structureSchemaFinder.getFieldDefinitionOrFallback(node.getType(), parameters.getEdgeType());
            if (fieldSchema.isList()) {
                ArrayList<Map<String, Object>> childObjects = new ArrayList<Map<String, Object>>();
                for (TraversableEdge edge : filteredEdges) {
                    GraphLoaderStepOutput child = this.resolveTraversableEdge(edge, edgeDescription, returnTypes);
                    if (returnTypes.contains((Object)GraphLoaderReturnType.GRAPH)) {
                        graph = graph.merge(child.getGraph());
                    }
                    if (!returnTypes.contains((Object)GraphLoaderReturnType.OBJECT)) continue;
                    childObjects.add(child.getObject());
                }
                if (!returnTypes.contains((Object)GraphLoaderReturnType.OBJECT)) continue;
                if (edgeDescription instanceof EdgeQueryDescription && !(edgeQueryDescription = (EdgeQueryDescription)((Object)edgeDescription)).isCompact()) {
                    object.put(String.format("%sConnections", parameters.getEdgeType()), childObjects);
                    continue;
                }
                object.put(parameters.getEdgeType(), childObjects);
                continue;
            }
            Map<String, Object> childObject = null;
            if (!filteredEdges.isEmpty()) {
                TraversableEdge edge = filteredEdges.get(0);
                GraphLoaderStepOutput child = this.resolveTraversableEdge(edge, edgeDescription, returnTypes);
                if (returnTypes.contains((Object)GraphLoaderReturnType.GRAPH)) {
                    graph = graph.merge(child.getGraph());
                }
                if (returnTypes.contains((Object)GraphLoaderReturnType.OBJECT)) {
                    childObject = child.getObject();
                }
            }
            if (!returnTypes.contains((Object)GraphLoaderReturnType.OBJECT)) continue;
            if (edgeDescription instanceof EdgeQueryDescription && !(edgeQueryDescription = (EdgeQueryDescription)((Object)edgeDescription)).isCompact()) {
                object.put(String.format("%sConnections", parameters.getEdgeType()), childObject);
                continue;
            }
            object.put(parameters.getEdgeType(), childObject);
        }
        return new GraphLoaderStepOutput(object, graph);
    }

    private GraphLoaderStepOutput resolveTraversableEdge(TraversableEdge edge, AbstractEdgeDescription graphDescription, Set<GraphLoaderReturnType> returnTypes) {
        List<AbstractNodeDescription> childNodeDescriptions = graphDescription.getChildGraphDescriptions().stream().filter(AbstractNodeDescription.class::isInstance).map(AbstractNodeDescription.class::cast).toList();
        Graph graph = new Graph();
        List<Attribute<?>> attributes = this.resolveAttributes((AttributeContainer)edge, graphDescription);
        if (returnTypes.contains((Object)GraphLoaderReturnType.GRAPH)) {
            Node nodeFrom = new Node(edge.getNodeFromId(), edge.getNodeFromType());
            Node nodeTo = new Node(edge.getNodeToId(), edge.getNodeToType());
            Edge inputEdge = new Edge(edge.getId(), nodeFrom, edge.getType(), nodeTo);
            for (Attribute<?> attribute2 : attributes) {
                inputEdge = inputEdge.add(attribute2);
            }
            graph = new Graph(new AttributeContainer[]{nodeFrom, nodeTo, inputEdge});
        }
        Map<String, Object> object = new HashMap<String, Object>();
        HashMap<String, Object> edgesObject = new HashMap<String, Object>();
        if (this.isMappingToConnectionObject(graphDescription, returnTypes)) {
            object.put("edges", edgesObject);
            attributes.forEach(attribute -> edgesObject.put(attribute.getName(), attribute.getValue()));
            if (graphDescription.getChildGraphDescriptions().stream().anyMatch(UuidIdentityDescription.class::isInstance)) {
                edgesObject.put("id", edge.getId().getId());
            }
        }
        if (childNodeDescriptions.isEmpty()) {
            return new GraphLoaderStepOutput(object, graph);
        }
        TraversableNode otherNode = graphDescription.isIngoing() ? edge.getNodeFrom() : edge.getNodeTo();
        Optional<AbstractNodeDescription> foundNodeDescription = childNodeDescriptions.stream().filter(nodeDescription -> ((NodeDescriptionParameters)nodeDescription.getParameters()).getNodeType().equals(otherNode.getType())).findFirst();
        if (foundNodeDescription.isPresent()) {
            GraphLoaderStepOutput graphLoaderStepOutput = this.resolveTraversableNode(otherNode, foundNodeDescription.get(), returnTypes);
            if (returnTypes.contains((Object)GraphLoaderReturnType.GRAPH)) {
                graph = graph.merge(graphLoaderStepOutput.getGraph());
            }
            if (returnTypes.contains((Object)GraphLoaderReturnType.OBJECT)) {
                EdgeQueryDescription edgeQueryDescription;
                if (graphDescription instanceof EdgeQueryDescription && !(edgeQueryDescription = (EdgeQueryDescription)((Object)graphDescription)).isCompact()) {
                    edgesObject.put("node", graphLoaderStepOutput.getObject());
                } else {
                    object = graphLoaderStepOutput.getObject();
                }
            }
            return new GraphLoaderStepOutput(object, graph);
        }
        return new GraphLoaderStepOutput(new HashMap<String, Object>(), new Graph());
    }

    private List<Attribute<?>> resolveAttributes(AttributeContainer graphElement, GraphDescription graphDescription) {
        List<GraphDescription> childGraphDescriptions = graphDescription.getChildGraphDescriptions();
        if (childGraphDescriptions.stream().anyMatch(AllAttributesDescription.class::isInstance)) {
            return graphElement.getVersionedAttributes().getVersionedAttributeList().stream().map(VersionedAttribute::getCurrent).collect(Collectors.toList());
        }
        ArrayList list = new ArrayList();
        childGraphDescriptions.stream().filter(AbstractAttributeDescription.class::isInstance).map(description -> (AttributeDescriptionParameters)description.getParameters()).filter(parameters -> graphElement.containsAttribute(parameters.getAttributeName())).forEach(parameters -> list.add(graphElement.getAttribute(parameters.getAttributeName())));
        return list;
    }

    private Object resolveSearchOptionStep(TraversableGraphElement element, PositiveGraphDescription graphDescription) {
        if (element instanceof TraversableNode) {
            TraversableNode node = (TraversableNode)element;
            return this.resolveNodeSearchOptionStep(node, (AbstractNodeDescription)graphDescription);
        }
        if (element instanceof TraversableEdge) {
            TraversableEdge edge = (TraversableEdge)element;
            return this.resolveEdgeSearchOptionStep(edge, (AbstractEdgeDescription)graphDescription);
        }
        throw new RuntimeException("There should never be any other graph element.");
    }

    private Object resolveNodeSearchOptionStep(TraversableNode node, AbstractNodeDescription graphDescription) {
        GraphDescription childDescription = graphDescription.getChildGraphDescriptions().get(0);
        if (childDescription instanceof AbstractEdgeDescription) {
            SearchQueryParameters searchQueryParameters;
            AbstractEdgeDescription edgeDescription = (AbstractEdgeDescription)childDescription;
            EdgeDescriptionParameters edgeParam = (EdgeDescriptionParameters)edgeDescription.getParameters();
            List edges = edgeDescription.isIngoing() ? node.getIngoingEdges(edgeParam.getEdgeType()) : node.getOutgoingEdges(edgeParam.getEdgeType());
            if (edgeDescription instanceof EdgeQueryDescription) {
                EdgeQueryDescription edgeQueryDescription = (EdgeQueryDescription)((Object)edgeDescription);
                searchQueryParameters = edgeQueryDescription.getSearchQueryParameters();
            } else {
                searchQueryParameters = SearchQueryParameters.from(new SearchOption[0]);
            }
            ArrayList<TraversableGraphElement> graphElements = new ArrayList<TraversableGraphElement>(edges);
            List<TraversableGraphElement> filteredGraphElements = this.applySearchQueryParameters(graphElements, searchQueryParameters, edgeDescription);
            return filteredGraphElements.stream().map(edge -> this.resolveEdgeSearchOptionStep((TraversableEdge)edge, edgeDescription)).collect(Collectors.toList());
        }
        if (childDescription instanceof AbstractAttributeDescription) {
            AbstractAttributeDescription attributeDescription = (AbstractAttributeDescription)childDescription;
            AttributeDescriptionParameters attributeParam = (AttributeDescriptionParameters)attributeDescription.getParameters();
            if (!node.hasAttribute(attributeParam.getAttributeName())) {
                return null;
            }
            return node.getAttribute(attributeParam.getAttributeName());
        }
        if (childDescription instanceof UuidIdentityDescription) {
            return new LeafAttribute("id", (AttributeValue)new IdAttributeValue(node.getId().getId()));
        }
        throw new RuntimeException("Should not ever happen, already validated.");
    }

    private Object resolveEdgeSearchOptionStep(TraversableEdge edge, AbstractEdgeDescription graphDescription) {
        GraphDescription childDescription = graphDescription.getChildGraphDescriptions().get(0);
        if (childDescription instanceof AbstractNodeDescription) {
            AbstractNodeDescription nodeDescription = (AbstractNodeDescription)childDescription;
            NodeDescriptionParameters nodeParam = (NodeDescriptionParameters)nodeDescription.getParameters();
            TraversableNode otherNode = graphDescription.isIngoing() ? edge.getNodeFrom() : edge.getNodeTo();
            if (!otherNode.getType().equals(nodeParam.getNodeType())) {
                return null;
            }
            return this.resolveNodeSearchOptionStep(otherNode, nodeDescription);
        }
        if (childDescription instanceof AbstractAttributeDescription) {
            AbstractAttributeDescription attributeDescription = (AbstractAttributeDescription)childDescription;
            AttributeDescriptionParameters attributeParam = (AttributeDescriptionParameters)attributeDescription.getParameters();
            if (!edge.hasAttribute(attributeParam.getAttributeName())) {
                return null;
            }
            return edge.getAttribute(attributeParam.getAttributeName());
        }
        if (childDescription instanceof UuidIdentityDescription) {
            return new LeafAttribute("id", (AttributeValue)new IdAttributeValue(edge.getId().getId()));
        }
        throw new RuntimeException("Should not ever happen, already validated.");
    }

    private boolean isMappingToConnectionObject(AbstractEdgeDescription graphDescription, Set<GraphLoaderReturnType> returnTypes) {
        if (!returnTypes.contains((Object)GraphLoaderReturnType.OBJECT)) {
            return false;
        }
        if (graphDescription instanceof EdgeQueryDescription) {
            EdgeQueryDescription edgeQueryDescription = (EdgeQueryDescription)((Object)graphDescription);
            return !edgeQueryDescription.isCompact();
        }
        return false;
    }

    private static class GraphLoaderStepOutput {
        private final Map<String, Object> object;
        private final Graph graph;

        public GraphLoaderStepOutput(Map<String, Object> object, Graph graph) {
            this.object = object;
            this.graph = graph;
        }

        public GraphLoaderStepOutput() {
            this(new HashMap<String, Object>(), new Graph());
        }

        public Map<String, Object> getObject() {
            return this.object;
        }

        public Graph getGraph() {
            return this.graph;
        }
    }
}

