/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphReader.mappingPartReadResolvers;

import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractAttributeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AttributeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.PositiveGraphDescription;
import ai.stapi.graphoperations.graphReader.mappingPartReadResolvers.GraphDescriptionReadResolver;
import ai.stapi.graphoperations.graphReader.mappingPartReadResolvers.exception.GraphDescriptionReadResolverException;
import ai.stapi.graphoperations.graphReader.readResults.AttributeReadResult;
import ai.stapi.graphoperations.graphReader.readResults.EdgeReadResult;
import ai.stapi.graphoperations.graphReader.readResults.NodeReadResult;
import ai.stapi.graphoperations.graphReader.readResults.ReadResult;
import java.util.List;

public class AttributeDescriptionReadResolver
implements GraphDescriptionReadResolver {
    @Override
    public List<ReadResult> resolve(ReadResult previousResult, PositiveGraphDescription graphDescription, InMemoryGraphRepository graph) {
        AttributeDescriptionParameters parameters = (AttributeDescriptionParameters)graphDescription.getParameters();
        if (previousResult instanceof NodeReadResult) {
            NodeReadResult nodeReadResult = (NodeReadResult)previousResult;
            TraversableNode node = graph.loadNode(nodeReadResult.getGraphElement().getId(), nodeReadResult.getGraphElement().getType());
            if (!node.hasAttribute(parameters.getAttributeName())) {
                return List.of();
            }
            return List.of(new AttributeReadResult(node.getAttribute(parameters.getAttributeName())));
        }
        if (previousResult instanceof EdgeReadResult) {
            EdgeReadResult edgeReadResult = (EdgeReadResult)previousResult;
            TraversableEdge edge = graph.loadEdge(edgeReadResult.getGraphElement().getId(), edgeReadResult.getGraphElement().getType());
            if (!edge.hasAttribute(parameters.getAttributeName())) {
                throw GraphDescriptionReadResolverException.becauseAttributeDoesNotExists(edge.getId(), parameters.getAttributeName());
            }
            return List.of(new AttributeReadResult(edge.getAttribute(parameters.getAttributeName())));
        }
        throw GraphDescriptionReadResolverException.becauseIngoingReadResultIsNotSupported(previousResult, this);
    }

    @Override
    public boolean supports(PositiveGraphDescription graphDescription) {
        return graphDescription instanceof AbstractAttributeDescription;
    }
}

