/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphLoader.search.filterOption.factory;

import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NullGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.PositiveGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.AttributeQueryDescription;
import ai.stapi.graphoperations.graphLoader.search.exceptions.CannotCreateFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.AbstractOneValueFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.AllMatchFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.AndFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.AnyMatchFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.CompositeFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.CompositeFilterParameters;
import ai.stapi.graphoperations.graphLoader.search.filterOption.ContainsFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.EndsWithFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.EqualsFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.FilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.FilterOptionParameters;
import ai.stapi.graphoperations.graphLoader.search.filterOption.GreaterThanFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.GreaterThanOrEqualFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.LowerThanFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.LowerThanOrEqualsFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.NoneMatchFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.NotEqualsFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.NotFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.OneValueFilterOptionParameters;
import ai.stapi.graphoperations.graphLoader.search.filterOption.OrFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.StartsWithFilterOption;
import java.util.ArrayList;
import java.util.List;

public class FilterOptionFactory {
    public FilterOption<?> create(String filterStrategy, FilterOptionParameters filterOptionParameters) {
        if (filterOptionParameters instanceof OneValueFilterOptionParameters) {
            OneValueFilterOptionParameters oneValueFilterOptionParameters = (OneValueFilterOptionParameters)filterOptionParameters;
            return this.createLeaf(filterStrategy, oneValueFilterOptionParameters.getAttributeNamePath(), oneValueFilterOptionParameters.getAttributeValue());
        }
        if (filterOptionParameters instanceof CompositeFilterParameters) {
            CompositeFilterParameters compositeFilterParameters = (CompositeFilterParameters)filterOptionParameters;
            return this.createComposite(filterStrategy, compositeFilterParameters.getChildFilterOptions());
        }
        throw CannotCreateFilterOption.becauseInvalidFilterOptionParameters(filterStrategy, filterOptionParameters);
    }

    public AbstractOneValueFilterOption<?> createLeaf(String filterStrategy, PositiveGraphDescription attributeNamePath, Object attributeValue) {
        if (filterStrategy.equals("contains")) {
            return new ContainsFilterOption(attributeNamePath, (String)attributeValue);
        }
        if (filterStrategy.equals("ends_with")) {
            return new EndsWithFilterOption(attributeNamePath, (String)attributeValue);
        }
        if (filterStrategy.equals("equals")) {
            return new EqualsFilterOption<Object>(attributeNamePath, attributeValue);
        }
        if (filterStrategy.equals("greater_than")) {
            return new GreaterThanFilterOption<Object>(attributeNamePath, attributeValue);
        }
        if (filterStrategy.equals("greater_than_or_equals")) {
            return new GreaterThanOrEqualFilterOption<Object>(attributeNamePath, attributeValue);
        }
        if (filterStrategy.equals("lower_than")) {
            return new LowerThanFilterOption<Object>(attributeNamePath, attributeValue);
        }
        if (filterStrategy.equals("lower_than_or_equals")) {
            return new LowerThanOrEqualsFilterOption<Object>(attributeNamePath, attributeValue);
        }
        if (filterStrategy.equals("not_equals")) {
            return new NotEqualsFilterOption<Object>(attributeNamePath, attributeValue);
        }
        if (filterStrategy.equals("starts_with")) {
            return new StartsWithFilterOption(attributeNamePath, (String)attributeValue);
        }
        throw CannotCreateFilterOption.becauseInvalidLeafFilterStrategyProvided(filterStrategy);
    }

    public AbstractOneValueFilterOption<?> createLeaf(String filterStrategy, String attributeName, Object attributeValue) {
        return this.createLeaf(filterStrategy, new AttributeQueryDescription(attributeName), attributeValue);
    }

    public FilterOption<?> createComposite(String filterStrategy, List<FilterOption<?>> childFilterOption) {
        try {
            return this.createList(filterStrategy, (AbstractOneValueFilterOption)childFilterOption.get(0));
        }
        catch (CannotCreateFilterOption cannotCreateFilterOption) {
            return this.createLogical(filterStrategy, childFilterOption);
        }
    }

    public FilterOption<?> createList(String filterStrategy, AbstractOneValueFilterOption<?> childFilterOption) {
        if (filterStrategy.equals("all_match")) {
            return new AllMatchFilterOption(childFilterOption);
        }
        if (filterStrategy.equals("any_match")) {
            return new AnyMatchFilterOption(childFilterOption);
        }
        if (filterStrategy.equals("none_match")) {
            return new NoneMatchFilterOption(childFilterOption);
        }
        throw CannotCreateFilterOption.becauseInvalidListFilterStrategyProvided(filterStrategy);
    }

    public FilterOption<?> createLogical(String filterStrategy, List<FilterOption<?>> childFilterOption) {
        if (filterStrategy.equals("and")) {
            return new AndFilterOption(childFilterOption);
        }
        if (filterStrategy.equals("or")) {
            return new OrFilterOption(childFilterOption);
        }
        if (filterStrategy.equals("not")) {
            return new NotFilterOption(childFilterOption.get(0));
        }
        throw CannotCreateFilterOption.becauseInvalidLogicalFilterStrategyProvided(filterStrategy);
    }

    public FilterOption<?> copyWithNewAttributeNamePath(FilterOption<?> originalFilter, PositiveGraphDescription attributeNamePath) {
        if (originalFilter instanceof CompositeFilterOption) {
            CompositeFilterOption compositeFilterOption = (CompositeFilterOption)originalFilter;
            ArrayList newChildren = new ArrayList();
            ((CompositeFilterParameters)compositeFilterOption.getParameters()).getChildFilterOptions().stream().map(child -> this.copyWithNewAttributeNamePath((FilterOption<?>)child, attributeNamePath)).forEach(newChildren::add);
            return this.createComposite(compositeFilterOption.getStrategy(), newChildren);
        }
        if (originalFilter instanceof AbstractOneValueFilterOption) {
            AbstractOneValueFilterOption oneValueFilterOption = (AbstractOneValueFilterOption)originalFilter;
            return this.createLeaf(oneValueFilterOption.getStrategy(), attributeNamePath, ((OneValueFilterOptionParameters)oneValueFilterOption.getParameters()).getAttributeValue());
        }
        throw CannotCreateFilterOption.becauseInvalidFilterOptionFoundWhenMakingCopy(originalFilter);
    }

    public PositiveGraphDescription getAttributeNamePath(FilterOption<?> filterOption) {
        if (filterOption instanceof CompositeFilterOption) {
            CompositeFilterOption compositeFilterOption = (CompositeFilterOption)filterOption;
            return this.getAttributeNamePath(((CompositeFilterParameters)compositeFilterOption.getParameters()).getChildFilterOptions().get(0));
        }
        if (filterOption instanceof AbstractOneValueFilterOption) {
            AbstractOneValueFilterOption oneValueFilterOption = (AbstractOneValueFilterOption)filterOption;
            return ((OneValueFilterOptionParameters)oneValueFilterOption.getParameters()).getAttributeNamePath();
        }
        return new NullGraphDescription();
    }
}

