/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.serializableGraph.jackson;

import ai.stapi.graph.Graph;
import ai.stapi.graph.graphelements.Edge;
import ai.stapi.graph.graphelements.Node;
import ai.stapi.graphoperations.serializableGraph.SerializableEdge;
import ai.stapi.graphoperations.serializableGraph.SerializableGraph;
import ai.stapi.graphoperations.serializableGraph.SerializableNode;
import ai.stapi.graphoperations.serializableGraph.deserializer.SerializableGraphDeserializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class SerializableGraphConfigurer {
    private final SerializableGraphDeserializer serializableGraphDeserializer;

    public SerializableGraphConfigurer(SerializableGraphDeserializer serializableGraphDeserializer) {
        this.serializableGraphDeserializer = serializableGraphDeserializer;
    }

    public void configure(ObjectMapper objectMapper) {
        SimpleModule inMemoryGraphModule = new SimpleModule("InMemoryGraphModule");
        inMemoryGraphModule.addSerializer(Graph.class, (JsonSerializer)new JsonSerializer<Graph>(){

            public void serialize(Graph value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeObject((Object)SerializableGraph.fromInMemory(value));
            }
        });
        inMemoryGraphModule.addDeserializer(Graph.class, (JsonDeserializer)new JsonDeserializer<Graph>(){

            public Graph deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                SerializableGraph serializableGraph = (SerializableGraph)p.readValueAs(SerializableGraph.class);
                return SerializableGraphConfigurer.this.serializableGraphDeserializer.deserialize(serializableGraph);
            }
        });
        inMemoryGraphModule.addSerializer(Node.class, (JsonSerializer)new JsonSerializer<Node>(){

            public void serialize(Node value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeObject((Object)SerializableNode.fromInputNode(value));
            }
        });
        inMemoryGraphModule.addDeserializer(Node.class, (JsonDeserializer)new JsonDeserializer<Node>(){

            public Node deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                SerializableNode serializableNode = (SerializableNode)p.readValueAs(SerializableNode.class);
                return SerializableGraphConfigurer.this.serializableGraphDeserializer.deserializeNode(serializableNode);
            }
        });
        inMemoryGraphModule.addSerializer(Edge.class, (JsonSerializer)new JsonSerializer<Edge>(){

            public void serialize(Edge value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeObject((Object)SerializableEdge.fromInputEdge(value));
            }
        });
        inMemoryGraphModule.addDeserializer(Edge.class, (JsonDeserializer)new JsonDeserializer<Edge>(){

            public Edge deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                SerializableEdge serializableEdge = (SerializableEdge)p.readValueAs(SerializableEdge.class);
                return SerializableGraphConfigurer.this.serializableGraphDeserializer.deserializeEdge(serializableEdge);
            }
        });
        objectMapper.registerModule((Module)inMemoryGraphModule);
    }
}

