/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.objectGraphMapper.model.specific;

import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.GraphDescriptionBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.InterfaceObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphMapper.model.GenericObjectGraphMapper;
import ai.stapi.graphoperations.objectGraphMapper.model.MissingFieldResolvingStrategy;
import ai.stapi.graphoperations.objectGraphMapper.model.specific.AbstractSpecificObjectGraphMapper;
import ai.stapi.graphoperations.objectGraphMapper.model.specific.InterfaceSpecificObjectGraphMapperFixStrategy;
import ai.stapi.graphoperations.objectGraphMapper.model.specific.exceptions.SpecificObjectGraphMapperException;
import ai.stapi.graphoperations.ogmProviders.GenericGraphMappingProvider;
import ai.stapi.serialization.SerializableObject;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class InterfaceSpecificObjectGraphMapper
extends AbstractSpecificObjectGraphMapper {
    private final GenericGraphMappingProvider mappingProvider;
    @Nullable
    private final InterfaceSpecificObjectGraphMapperFixStrategy interfaceSpecificObjectGraphMapperFixStrategy;

    public InterfaceSpecificObjectGraphMapper(GenericObjectGraphMapper genericGraphMapper, GenericGraphMappingProvider mappingProvider, @Nullable InterfaceSpecificObjectGraphMapperFixStrategy interfaceSpecificObjectGraphMapperFixStrategy) {
        super(genericGraphMapper);
        this.mappingProvider = mappingProvider;
        this.interfaceSpecificObjectGraphMapperFixStrategy = interfaceSpecificObjectGraphMapperFixStrategy;
    }

    @Override
    public GraphDescriptionBuilder createGraphDescriptionWithValues(ObjectGraphMapping objectGraphMapping, Map.Entry<String, Object> fieldEntry, GraphDescriptionBuilder builder, MissingFieldResolvingStrategy missingFieldResolvingStrategy) {
        String serializationType;
        Object object = fieldEntry.getValue();
        if (object instanceof Map) {
            Map map = (Map)object;
            serializationType = this.getSerializationTypeFromMap(map);
        } else {
            object = fieldEntry.getValue();
            if (object instanceof SerializableObject) {
                SerializableObject serializableObject = (SerializableObject)object;
                serializationType = serializableObject.getSerializationType();
            } else {
                throw SpecificObjectGraphMapperException.becauseActualEntityBehindInterfaceIsNotObject(fieldEntry.getValue());
            }
        }
        if (this.isNullDeclaration(serializationType)) {
            return builder;
        }
        if (serializationType.isBlank()) {
            throw SpecificObjectGraphMapperException.becauseSerializationTypeWasNotFound(fieldEntry.getKey(), fieldEntry.getValue());
        }
        ObjectGraphMapping mappingDefinition = this.mappingProvider.provideGraphMapping(serializationType, fieldEntry.getKey());
        InterfaceObjectGraphMapping interfaceObjectGraphMapping = (InterfaceObjectGraphMapping)objectGraphMapping;
        if (this.interfaceSpecificObjectGraphMapperFixStrategy != null) {
            interfaceObjectGraphMapping = this.interfaceSpecificObjectGraphMapperFixStrategy.fix(interfaceObjectGraphMapping, fieldEntry, builder, serializationType);
        }
        GraphDescriptionBuilder resolvedBuilder = this.addGraphDescriptionCompositeToBuilder(interfaceObjectGraphMapping.getGraphDescription(), builder);
        this.genericGraphMapper.resolveInternally(mappingDefinition, fieldEntry, resolvedBuilder, missingFieldResolvingStrategy);
        return resolvedBuilder;
    }

    private String getSerializationTypeFromMap(Map map) {
        return map.getOrDefault("serializationType", "");
    }

    @Override
    public boolean supports(ObjectGraphMapping objectGraphMapping) {
        return objectGraphMapping instanceof InterfaceObjectGraphMapping;
    }

    private boolean isNullDeclaration(String serializationType) {
        return serializationType.equals("NullGraphDescription");
    }
}

