/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphDeserializers.ogmDeserializer.specific;

import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableGraphElement;
import ai.stapi.graphoperations.graphDeserializers.ogmDeserializer.GenericGraphToObjectDeserializer;
import ai.stapi.graphoperations.graphDeserializers.ogmDeserializer.MissingTraversalTargetResolvingStrategy;
import ai.stapi.graphoperations.graphDeserializers.ogmDeserializer.exception.GenericGraphOgmDeserializerException;
import ai.stapi.graphoperations.graphDeserializers.ogmDeserializer.specific.AbstractSpecificGraphToObjectDeserializer;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NullGraphDescription;
import ai.stapi.graphoperations.graphReader.GraphReader;
import ai.stapi.graphoperations.objectGraphLanguage.InterfaceObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectObjectGraphMapping;
import ai.stapi.graphoperations.ogmProviders.GenericGraphMappingProvider;
import ai.stapi.graphoperations.serializationTypeProvider.GenericSerializationTypeByNodeProvider;
import java.util.List;
import java.util.Map;

public class InterfaceGraphToObjectDeserializer
extends AbstractSpecificGraphToObjectDeserializer {
    public InterfaceGraphToObjectDeserializer(GraphReader graphReader, GenericGraphToObjectDeserializer genericDeserializer, GenericSerializationTypeByNodeProvider serializationTypeProvider, GenericGraphMappingProvider mappingProvider) {
        super(graphReader, genericDeserializer, serializationTypeProvider, mappingProvider);
    }

    @Override
    public Object deserialize(List<TraversableGraphElement> elements, GraphDescription lastGraphDescription, ObjectGraphMapping graphMapping, InMemoryGraphRepository contextualGraph, MissingTraversalTargetResolvingStrategy missingTraversalTargetResolvingStrategy) {
        if (elements.size() == 0) {
            return null;
        }
        if (elements.size() > 1) {
            throw GenericGraphOgmDeserializerException.becauseThereIsMultipleGraphBranchesButMappingIsNotForList();
        }
        TraversableGraphElement rootElement = (elements = this.ensureElementsAreNodes(elements, lastGraphDescription)).get(0);
        if (!this.serializationTypeProvider.existsSerializationTypeForNode(rootElement)) {
            throw GenericGraphOgmDeserializerException.becauseNodeTypeIsNotSupported(rootElement.getType());
        }
        String serializationType = this.serializationTypeProvider.getSerializationType(rootElement);
        ObjectObjectGraphMapping objectGraphMapping = (ObjectObjectGraphMapping)this.mappingProvider.provideGraphMapping(serializationType);
        Map objectMap = (Map)this.genericDeserializer.resolveInternally(elements, new NullGraphDescription(), objectGraphMapping, contextualGraph, missingTraversalTargetResolvingStrategy);
        objectMap.put("serializationType", serializationType);
        return objectMap;
    }

    @Override
    public boolean supports(ObjectGraphMapping objectGraphMapping, List<TraversableGraphElement> elements) {
        return objectGraphMapping instanceof InterfaceObjectGraphMapping;
    }
}

