/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphLoader.graphLoaderOGMFactory;

import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.GraphDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractAttributeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractEdgeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractNodeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AttributeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.EdgeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.GraphElementTypeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.UuidIdentityDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.EdgeQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.IngoingEdgeQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.NodeQueryGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.OutgoingEdgeQueryDescription;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.ObjectGraphMappingBuilder;

public class GraphLoaderOgmFactory {
    public ObjectGraphMapping create(GraphDescription graphDescription) {
        ObjectGraphMappingBuilder ogmBuilder = new ObjectGraphMappingBuilder();
        ogmBuilder.setGraphDescription(new GraphDescriptionBuilder().copyWithNewChildren(graphDescription, new GraphDescription[0]));
        graphDescription.getChildGraphDescriptions().forEach(childDescription -> this.resolveChildGraphDescription((GraphDescription)childDescription, ogmBuilder));
        return ogmBuilder.build();
    }

    private void resolveChildGraphDescription(GraphDescription graphDescription, ObjectGraphMappingBuilder ogmBuilder) {
        if (graphDescription instanceof AbstractNodeDescription) {
            NodeDescriptionParameters nodeParam = (NodeDescriptionParameters)graphDescription.getParameters();
            ObjectGraphMappingBuilder childOgmBuilder = ogmBuilder.addField(nodeParam.getNodeType()).addObjectAsObjectFieldMapping();
            if (graphDescription instanceof NodeQueryGraphDescription) {
                NodeQueryGraphDescription nodeQueryGraphDescription = (NodeQueryGraphDescription)graphDescription;
                childOgmBuilder.setGraphDescription(new NodeQueryGraphDescription(nodeParam, nodeQueryGraphDescription.getSearchQueryParameters(), nodeQueryGraphDescription.getChildGraphDescriptions()));
            } else {
                childOgmBuilder.setGraphDescription(new GraphDescriptionBuilder().addNodeDescription(nodeParam.getNodeType()));
            }
            graphDescription.getChildGraphDescriptions().forEach(childDescription -> this.resolveChildGraphDescription((GraphDescription)childDescription, childOgmBuilder));
        }
        if (graphDescription instanceof AbstractEdgeDescription) {
            AbstractEdgeDescription edgeDescription = (AbstractEdgeDescription)graphDescription;
            EdgeDescriptionParameters edgeParam = (EdgeDescriptionParameters)edgeDescription.getParameters();
            ObjectGraphMappingBuilder childOgmBuilder = ogmBuilder.addField(edgeParam.getEdgeType()).addListAsObjectFieldMapping().addObjectChildDefinition();
            if (edgeDescription instanceof EdgeQueryDescription) {
                EdgeQueryDescription edgeQueryDescription = (EdgeQueryDescription)((Object)edgeDescription);
                if (edgeDescription.isOutgoing()) {
                    if (edgeQueryDescription.isCompact()) {
                        childOgmBuilder.setGraphDescription(new OutgoingEdgeQueryDescription((EdgeDescriptionParameters)edgeQueryDescription.getParameters(), edgeQueryDescription.getSearchQueryParameters(), new GraphDescription[0]));
                    } else {
                        childOgmBuilder.setGraphDescription(OutgoingEdgeQueryDescription.asConnections((EdgeDescriptionParameters)edgeQueryDescription.getParameters(), edgeQueryDescription.getSearchQueryParameters(), new GraphDescription[0]));
                    }
                } else if (edgeQueryDescription.isCompact()) {
                    childOgmBuilder.setGraphDescription(new IngoingEdgeQueryDescription((EdgeDescriptionParameters)edgeQueryDescription.getParameters(), edgeQueryDescription.getSearchQueryParameters(), new GraphDescription[0]));
                } else {
                    childOgmBuilder.setGraphDescription(IngoingEdgeQueryDescription.asConnections((EdgeDescriptionParameters)edgeQueryDescription.getParameters(), edgeQueryDescription.getSearchQueryParameters(), new GraphDescription[0]));
                }
            } else if (edgeDescription.isOutgoing()) {
                childOgmBuilder.setGraphDescription(new GraphDescriptionBuilder().addOutgoingEdge(edgeParam.getEdgeType()));
            } else {
                childOgmBuilder.setGraphDescription(new GraphDescriptionBuilder().addIngoingEdge(edgeParam.getEdgeType()));
            }
            graphDescription.getChildGraphDescriptions().forEach(childDescription -> this.resolveChildGraphDescription((GraphDescription)childDescription, childOgmBuilder));
        }
        if (graphDescription instanceof AbstractAttributeDescription) {
            AttributeDescriptionParameters attributeParams = (AttributeDescriptionParameters)graphDescription.getParameters();
            ogmBuilder.addField(attributeParams.getAttributeName()).addLeafAsObjectFieldMapping().setGraphDescription(graphDescription);
        }
        if (graphDescription instanceof UuidIdentityDescription) {
            ogmBuilder.addField("id").addLeafAsObjectFieldMapping().setGraphDescription(graphDescription);
        }
        if (graphDescription instanceof GraphElementTypeDescription) {
            ogmBuilder.addField("graphElementType").addLeafAsObjectFieldMapping().setGraphDescription(graphDescription);
        }
    }
}

