/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphLoader.inmemory.filter;

import ai.stapi.graph.attribute.Attribute;
import ai.stapi.graph.attribute.ListAttribute;
import ai.stapi.graph.attribute.SetAttribute;
import ai.stapi.graph.traversableGraphElements.TraversableGraphElement;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.GraphDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.PositiveGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.CollectionComparisonOperator;
import ai.stapi.graphoperations.graphLoader.inmemory.InMemoryGraphLoader;
import ai.stapi.graphoperations.graphLoader.inmemory.InMemorySearchResolvingContext;
import ai.stapi.graphoperations.graphLoader.inmemory.filter.GenericInMemoryFilterOptionResolver;
import ai.stapi.graphoperations.graphLoader.inmemory.filter.InMemoryFilterResolver;
import ai.stapi.graphoperations.graphLoader.search.AbstractSearchOptionResolver;
import ai.stapi.graphoperations.graphLoader.search.filterOption.AbstractCompositeFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.AbstractOneValueFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.CompositeFilterParameters;
import ai.stapi.graphoperations.graphLoader.search.filterOption.FilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.OneValueFilterOptionParameters;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.List;

public abstract class InMemoryArrayComparisonFilterResolver
extends InMemoryFilterResolver {
    protected final GenericInMemoryFilterOptionResolver genericInMemoryFilterOptionResolver;
    private final InMemoryGraphLoader inMemoryGraphLoader;

    protected InMemoryArrayComparisonFilterResolver(StructureSchemaFinder structureSchemaFinder, GenericInMemoryFilterOptionResolver genericInMemoryFilterOptionResolver, InMemoryGraphLoader inMemoryGraphLoader) {
        super(structureSchemaFinder);
        this.genericInMemoryFilterOptionResolver = genericInMemoryFilterOptionResolver;
        this.inMemoryGraphLoader = inMemoryGraphLoader;
    }

    protected abstract boolean resolveListAttribute(AbstractOneValueFilterOption<?> var1, ListAttribute var2);

    protected abstract boolean resolveSetAttribute(AbstractOneValueFilterOption<?> var1, SetAttribute var2);

    @Override
    public boolean resolveElement(FilterOption<?> option, TraversableGraphElement element, InMemorySearchResolvingContext context) {
        AbstractCompositeFilterOption compositeFilterOption = (AbstractCompositeFilterOption)option;
        AbstractOneValueFilterOption childFilter = (AbstractOneValueFilterOption)((CompositeFilterParameters)compositeFilterOption.getParameters()).getChildFilterOptions().get(0);
        if (childFilter.isLeaf() && childFilter.isDescribingAttribute()) {
            String attributeName = ((OneValueFilterOptionParameters)childFilter.getParameters()).getAttributeName();
            Attribute attribute = element.getAttribute(attributeName);
            if (attribute instanceof ListAttribute) {
                ListAttribute listAttribute = (ListAttribute)attribute;
                return this.resolveListAttribute(childFilter, listAttribute);
            }
            if (attribute instanceof SetAttribute) {
                SetAttribute setAttribute = (SetAttribute)attribute;
                return this.resolveSetAttribute(childFilter, setAttribute);
            }
        }
        PositiveGraphDescription attributeNamePath = ((OneValueFilterOptionParameters)childFilter.getParameters()).getAttributeNamePath();
        GraphDescription copy = new GraphDescriptionBuilder().copyWithNewChildren((GraphDescription)context.getLastDescription(), attributeNamePath);
        Object filterValue = this.inMemoryGraphLoader.getSearchOptionAttributeValue(element.getId(), (PositiveGraphDescription)copy);
        List<AbstractSearchOptionResolver.SchemaAndCollectionComparisonOperator> collectionComparisonSchema = this.createRelationshipStructureSchema(attributeNamePath, element.getType());
        return this.resolveFilterValue(childFilter, filterValue, collectionComparisonSchema);
    }

    private boolean resolveFilterValue(AbstractOneValueFilterOption<?> filterOption, Object filterValue, List<AbstractSearchOptionResolver.SchemaAndCollectionComparisonOperator> collectionComparisonSchema) {
        if (filterValue == null) {
            return false;
        }
        if (collectionComparisonSchema.isEmpty()) {
            Attribute attribute = (Attribute)filterValue;
            if (attribute instanceof ListAttribute) {
                ListAttribute listAttribute = (ListAttribute)attribute;
                return this.resolveListAttribute(filterOption, listAttribute);
            }
            if (attribute instanceof SetAttribute) {
                SetAttribute setAttribute = (SetAttribute)attribute;
                return this.resolveSetAttribute(filterOption, setAttribute);
            }
            return false;
        }
        AbstractSearchOptionResolver.SchemaAndCollectionComparisonOperator currentComparison = collectionComparisonSchema.get(0);
        List list = (List)filterValue;
        int len = collectionComparisonSchema.size();
        List<AbstractSearchOptionResolver.SchemaAndCollectionComparisonOperator> restOfCollectionSchema = collectionComparisonSchema.subList(1, len);
        if (currentComparison.operator().equals((Object)CollectionComparisonOperator.ALL)) {
            return list.stream().allMatch(value -> this.resolveFilterValue(filterOption, value, restOfCollectionSchema));
        }
        if (currentComparison.operator().equals((Object)CollectionComparisonOperator.NONE)) {
            return list.stream().noneMatch(value -> this.resolveFilterValue(filterOption, value, restOfCollectionSchema));
        }
        return list.stream().anyMatch(value -> this.resolveFilterValue(filterOption, value, restOfCollectionSchema));
    }
}

