/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphWriter.specific;

import ai.stapi.graph.attribute.attributeFactory.AttributeValueFactoryInput;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractAttributeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractAttributeValueDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AttributeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.ConstantDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.ConstantDescriptionParameters;
import ai.stapi.graphoperations.graphWriter.SpecificGraphWriter;
import ai.stapi.graphoperations.graphWriter.exceptions.SpecificGraphWriterException;
import ai.stapi.graphoperations.graphbuilder.GraphBuilder;
import ai.stapi.graphoperations.graphbuilder.specific.positive.AttributeBuilder;
import java.util.List;

public class AttributeGraphWriter
implements SpecificGraphWriter {
    @Override
    public GraphBuilder write(GraphDescription graphDescription, GraphBuilder builder) {
        if (!(graphDescription instanceof AbstractAttributeDescription)) {
            throw new RuntimeException("Should not ever happen, because of supports.");
        }
        AbstractAttributeDescription attributeDescription = (AbstractAttributeDescription)graphDescription;
        AttributeDescriptionParameters parameters = (AttributeDescriptionParameters)attributeDescription.getParameters();
        AttributeBuilder attributeBuilder = builder.addAttributeToLastElement();
        attributeBuilder.setAttributeName(parameters.getAttributeName()).setAttributeStructureType(attributeDescription.getDescribedAttributeStructureType());
        List<AbstractAttributeValueDescription> attributeValuesDescriptions = attributeDescription.getChildGraphDescriptions().stream().filter(AbstractAttributeValueDescription.class::isInstance).map(AbstractAttributeValueDescription.class::cast).toList();
        attributeValuesDescriptions.forEach(valueDescription -> {
            GraphDescription constant = valueDescription.getChildGraphDescriptions().stream().filter(ConstantDescription.class::isInstance).findAny().orElseThrow(() -> SpecificGraphWriterException.becauseProvidedAttributeValueDoesNotContainAnyConstantDescription(valueDescription));
            ConstantDescriptionParameters constantParameters = (ConstantDescriptionParameters)constant.getParameters();
            Object value = constantParameters.getValue();
            attributeBuilder.addAttributeValue(new AttributeValueFactoryInput(value, valueDescription.getDescribedAttributeDataTypeId()));
        });
        return builder;
    }

    @Override
    public boolean supports(GraphDescription graphDescription) {
        return graphDescription instanceof AbstractAttributeDescription;
    }
}

