/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.serializableGraph;

import ai.stapi.graph.NodeIdAndType;
import ai.stapi.graph.graphelements.Edge;
import ai.stapi.graphoperations.serializableGraph.SerializableAttributeVersion;
import ai.stapi.graphoperations.serializableGraph.SerializableGraphElement;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SerializableEdge
extends SerializableGraphElement {
    private final NodeIdAndType nodeFrom;
    private final NodeIdAndType nodeTo;

    public static SerializableEdge fromInputEdge(Edge edge) {
        HashMap<String, List<SerializableAttributeVersion>> attributeMap = new HashMap<String, List<SerializableAttributeVersion>>();
        edge.getVersionedAttributes().getVersionedAttributeList().forEach(attr -> attributeMap.put(attr.getName(), attr.streamAttributeVersions().map(SerializableAttributeVersion::fromAttribute).toList()));
        return new SerializableEdge(edge.getId().getId(), edge.getType(), attributeMap, edge.getNodeFromIdAndType(), edge.getNodeToIdAndType());
    }

    public SerializableEdge(String id, String type, Map<String, List<SerializableAttributeVersion>> attributes, NodeIdAndType nodeFrom, NodeIdAndType nodeTo) {
        super(id, type, attributes);
        this.nodeFrom = nodeFrom;
        this.nodeTo = nodeTo;
    }

    @JsonCreator
    private SerializableEdge(@JsonProperty(value="_id") String reference, @JsonProperty(value="attributes") Map<String, List<SerializableAttributeVersion>> attributes, @JsonProperty(value="_from") String from, @JsonProperty(value="_to") String to, @JsonProperty(value="_rev") String revision, @JsonProperty(value="_key") String key) {
        super(reference, attributes, key, revision);
        this.nodeFrom = NodeIdAndType.fromString((String)from);
        this.nodeTo = NodeIdAndType.fromString((String)to);
    }

    @JsonProperty(value="_from")
    public String getFrom() {
        return this.getNodeFrom().toString();
    }

    @JsonProperty(value="_to")
    public String getTo() {
        return this.getNodeTo().toString();
    }

    @JsonIgnore
    public NodeIdAndType getNodeFrom() {
        return this.nodeFrom;
    }

    @JsonIgnore
    public NodeIdAndType getNodeTo() {
        return this.nodeTo;
    }
}

