/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphReader.mappingPartReadResolvers;

import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.PositiveGraphDescription;
import ai.stapi.graphoperations.graphReader.mappingPartReadResolvers.GraphDescriptionReadResolver;
import ai.stapi.graphoperations.graphReader.mappingPartReadResolvers.exception.GraphDescriptionReadResolverException;
import ai.stapi.graphoperations.graphReader.readResults.EdgeReadResult;
import ai.stapi.graphoperations.graphReader.readResults.NodeReadResult;
import ai.stapi.graphoperations.graphReader.readResults.ReadResult;
import java.util.List;

public class NodeDescriptionReadResolver
implements GraphDescriptionReadResolver {
    @Override
    public List<ReadResult> resolve(ReadResult previousResult, PositiveGraphDescription graphDescription, InMemoryGraphRepository contextualGraph) {
        TraversableNode node;
        if (!(previousResult instanceof EdgeReadResult)) {
            throw GraphDescriptionReadResolverException.becauseIngoingReadResultIsNotSupported(previousResult, this);
        }
        EdgeReadResult edgeReadResult = (EdgeReadResult)previousResult;
        NodeDescriptionParameters params = (NodeDescriptionParameters)graphDescription.getParameters();
        if (edgeReadResult.getEdge().getNodeToType().equals(params.getNodeType())) {
            node = edgeReadResult.getEdge().getNodeTo();
        } else if (edgeReadResult.getEdge().getNodeFromType().equals(params.getNodeType())) {
            node = edgeReadResult.getEdge().getNodeFrom();
        } else {
            throw GraphDescriptionReadResolverException.becauseEdgeDoesNotContainNodeOfGivenType(edgeReadResult.getGraphElement().getId(), params.getNodeType());
        }
        return List.of(new NodeReadResult(node));
    }

    @Override
    public boolean supports(PositiveGraphDescription graphDescription) {
        return graphDescription instanceof NodeDescription;
    }
}

