/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.dagtoobjectconverter;

import ai.stapi.graph.attribute.Attribute;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphoperations.dagtoobjectconverter.exceptions.CannotConvertDAGToObject;
import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DAGToObjectConverter {
    private static final String ID_FIELD_NAME = "id";
    private final StructureSchemaFinder structureSchemaFinder;

    public DAGToObjectConverter(StructureSchemaFinder structureSchemaFinder) {
        this.structureSchemaFinder = structureSchemaFinder;
    }

    public Map<String, Object> convert(TraversableNode startNode) throws CannotConvertDAGToObject {
        return new Convertor(this.structureSchemaFinder).convert(startNode);
    }

    private static class Convertor {
        private final NodeSet nodeSet = new NodeSet();
        private final StructureSchemaFinder structureSchemaFinder;

        public Convertor(StructureSchemaFinder structureSchemaFinder) {
            this.structureSchemaFinder = structureSchemaFinder;
        }

        public Map<String, Object> convert(TraversableNode startNode) throws CannotConvertDAGToObject {
            this.nodeSet.saveNode(startNode);
            HashMap<String, Object> object = this.convertNodeToObject(startNode);
            startNode.getOutgoingEdges().stream().sorted(Comparator.comparingInt(TraversableEdge::hashCode)).forEach(edge -> {
                TraversableNode nodeTo = edge.getNodeTo();
                if (this.nodeSet.hasNode(nodeTo)) {
                    throw CannotConvertDAGToObject.becauseItContainsCycle(nodeTo);
                }
                FieldDefinition fieldDefinition = this.structureSchemaFinder.getFieldDefinitionOrFallback(startNode.getType(), edge.getType());
                if (fieldDefinition.isList()) {
                    List list = (List)object.computeIfAbsent(edge.getType(), key -> new ArrayList());
                    list.add(this.convert(nodeTo));
                } else {
                    object.put(edge.getType(), this.convert(nodeTo));
                }
            });
            return object;
        }

        @NotNull
        private HashMap<String, Object> convertNodeToObject(TraversableNode startNode) {
            HashMap<String, Object> object = new HashMap<String, Object>(Map.of(DAGToObjectConverter.ID_FIELD_NAME, startNode.getId().getId()));
            startNode.getVersionedAttributeList().forEach(versionedAttribute -> {
                Attribute current = versionedAttribute.getCurrent();
                object.put(current.getName(), current.getValue());
            });
            return object;
        }
    }

    private static class NodeSet {
        private final Map<String, Set<UniqueIdentifier>> visitedNodes = new HashMap<String, Set<UniqueIdentifier>>();

        public void saveNode(TraversableNode node) {
            this.visitedNodes.computeIfAbsent(node.getType(), key -> new HashSet()).add(node.getId());
        }

        public boolean hasNode(TraversableNode node) {
            Set<UniqueIdentifier> nodesByType = this.visitedNodes.get(node.getType());
            return nodesByType != null && nodesByType.contains(node.getId());
        }
    }
}

