/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder;

import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.exception.GraphDescriptionBuilderException;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.SpecificGraphDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.AbstractAttributeDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.AbstractAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.AbstractPositiveDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.Base64BinaryAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.BooleanAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.CanonicalAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.CodeAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.ConstantSpecificDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.DateAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.DateTimeAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.DecimalAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.EdgeDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.IdAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.InstantAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.IntegerAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.InterfaceDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.LeafAttributeDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.ListAttributeDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.MarkdownAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.NodeDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.NullSpecificDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.OidAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.PositiveIntegerAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.ReferenceDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.SetAttributeDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.StringAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.TimeAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.UnsignedIntegerAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.UriAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.UrlAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.UuidAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.UuidSpecificDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.positive.XhtmlAttributeValueDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.query.AttributeQueryDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.removal.AbstractRemovalDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.removal.RemovalEdgeDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.specificDescriptionBuilders.removal.RemovalNodeDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractAttributeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NullGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.PositiveGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.UuidIdentityDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.removal.RemovalGraphDescription;
import ai.stapi.graphoperations.graphbuilder.specific.positive.EdgeDirection;
import ai.stapi.utils.Classifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class GraphDescriptionBuilder {
    private final List<SpecificGraphDescriptionBuilder> immutableSupportingSpecificBuilders;
    private SpecificGraphDescriptionBuilder descriptionBuilder;
    private List<GraphDescriptionBuilder> childBranches = new ArrayList<GraphDescriptionBuilder>();
    private GraphDescriptionBuilder parent;

    public GraphDescriptionBuilder() {
        this.immutableSupportingSpecificBuilders = List.of(new UuidSpecificDescriptionBuilder(), new NodeDescriptionBuilder(), new EdgeDescriptionBuilder(), new StringAttributeValueDescriptionBuilder(), new IntegerAttributeValueDescriptionBuilder(), new BooleanAttributeValueDescriptionBuilder(), new InstantAttributeValueDescriptionBuilder(), new TimeAttributeValueDescriptionBuilder(), new DateAttributeValueDescriptionBuilder(), new DateTimeAttributeValueDescriptionBuilder(), new Base64BinaryAttributeValueDescriptionBuilder(), new UrlAttributeValueDescriptionBuilder(), new CodeAttributeValueDescriptionBuilder(), new UriAttributeValueDescriptionBuilder(), new CanonicalAttributeValueDescriptionBuilder(), new MarkdownAttributeValueDescriptionBuilder(), new IdAttributeValueDescriptionBuilder(), new OidAttributeValueDescriptionBuilder(), new UuidAttributeValueDescriptionBuilder(), new UnsignedIntegerAttributeValueDescriptionBuilder(), new PositiveIntegerAttributeValueDescriptionBuilder(), new ConstantSpecificDescriptionBuilder(), new NullSpecificDescriptionBuilder(), new RemovalNodeDescriptionBuilder(), new RemovalEdgeDescriptionBuilder(), new InterfaceDescriptionBuilder(), new DecimalAttributeValueDescriptionBuilder(), new XhtmlAttributeValueDescriptionBuilder(), new ReferenceDescriptionBuilder(), new LeafAttributeDescriptionBuilder(), new ListAttributeDescriptionBuilder(), new SetAttributeDescriptionBuilder(), new AttributeQueryDescriptionBuilder());
    }

    private GraphDescriptionBuilder(GraphDescriptionBuilder parent) {
        this();
        this.parent = parent;
    }

    public static Stream<GraphDescription> getGraphDescriptionAsStream(GraphDescription graphDescription) {
        ArrayList<GraphDescription> allGraphDescriptions = new ArrayList<GraphDescription>();
        GraphDescriptionBuilder.addAllGraphDescriptionsInComposite(graphDescription, allGraphDescriptions);
        return allGraphDescriptions.stream();
    }

    public static boolean isGraphDescriptionSinglePath(GraphDescription graphDescription) {
        List<GraphDescription> childGraphDescriptions = graphDescription.getChildGraphDescriptions();
        if (childGraphDescriptions.size() > 1) {
            return false;
        }
        if (childGraphDescriptions.size() == 1) {
            return GraphDescriptionBuilder.isGraphDescriptionSinglePath(childGraphDescriptions.get(0));
        }
        return true;
    }

    public static boolean isGraphDescriptionEndingWithAttributeDescription(GraphDescription graphDescription) {
        List<GraphDescription> children = graphDescription.getChildGraphDescriptions();
        if (children.isEmpty() && graphDescription instanceof AbstractAttributeDescription) {
            return true;
        }
        if (children.isEmpty()) {
            return false;
        }
        return children.stream().allMatch(GraphDescriptionBuilder::isGraphDescriptionEndingWithAttributeDescription);
    }

    public static boolean isGraphDescriptionEndingWithAttributeOrUuidDescription(GraphDescription graphDescription) {
        List<GraphDescription> children = graphDescription.getChildGraphDescriptions();
        if (children.isEmpty() && GraphDescriptionBuilder.isInstanceOfUuidIdentityOrAttributeDescription(graphDescription)) {
            return true;
        }
        if (children.isEmpty()) {
            return false;
        }
        return children.stream().allMatch(GraphDescriptionBuilder::isGraphDescriptionEndingWithAttributeOrUuidDescription);
    }

    private static void addAllGraphDescriptionsInComposite(GraphDescription graphDescription, List<GraphDescription> listOfGraphDescriptions) {
        listOfGraphDescriptions.add(graphDescription);
        graphDescription.getChildGraphDescriptions().forEach(child -> GraphDescriptionBuilder.addAllGraphDescriptionsInComposite(child, listOfGraphDescriptions));
    }

    public GraphDescription copyWithNewChildren(GraphDescription graphDescription, List<GraphDescription> newChildren) {
        SpecificGraphDescriptionBuilder supportingBuilder = this.getRepresentingBuilder(graphDescription);
        return supportingBuilder.copyWithNewChildren(graphDescription, newChildren);
    }

    public GraphDescription copyWithNewChildren(GraphDescription graphDescription, GraphDescription ... newChildren) {
        SpecificGraphDescriptionBuilder supportingBuilder = this.getRepresentingBuilder(graphDescription);
        return supportingBuilder.copyWithNewChildren(graphDescription, Arrays.stream(newChildren).collect(Collectors.toCollection(ArrayList::new)));
    }

    public GraphDescription addToDeepestDescription(GraphDescription mainDescription, List<GraphDescription> childDescriptions) {
        if (!GraphDescriptionBuilder.isGraphDescriptionSinglePath(mainDescription)) {
            throw GraphDescriptionBuilderException.becauseToAddToDeepestGraphDescriptionItMustBeSinglePath(mainDescription);
        }
        return this.privateAddToDeepestDescription(mainDescription, childDescriptions);
    }

    private GraphDescription privateAddToDeepestDescription(GraphDescription mainDescription, List<GraphDescription> childDescriptions) {
        SpecificGraphDescriptionBuilder supportingBuilder = this.getRepresentingBuilder(mainDescription);
        if (mainDescription.getChildGraphDescriptions().isEmpty()) {
            return supportingBuilder.copyWithNewChildren(mainDescription, childDescriptions);
        }
        return supportingBuilder.copyWithNewChildren(mainDescription, List.of(this.privateAddToDeepestDescription(mainDescription.getChildGraphDescriptions().get(0), childDescriptions)));
    }

    public GraphDescription filterOutNullDescriptions(GraphDescription graphDescription) {
        return new GraphDescriptionBuilder().copyWithNewChildren(graphDescription, graphDescription.getChildGraphDescriptions().stream().flatMap(GraphDescriptionBuilder::filterOutNull).toList());
    }

    @NotNull
    private static Stream<GraphDescription> filterOutNull(GraphDescription child) {
        GraphDescriptionBuilder builder = new GraphDescriptionBuilder();
        if (child instanceof NullGraphDescription) {
            return child.getChildGraphDescriptions().stream().flatMap(GraphDescriptionBuilder::filterOutNull);
        }
        return Stream.of(builder.filterOutNullDescriptions(child));
    }

    public GraphDescriptionBuilder addNodeDescription(String nodeType) {
        NodeDescriptionBuilder builder = new NodeDescriptionBuilder().setNodeType(nodeType);
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addOutgoingEdge(String edgeType) {
        EdgeDescriptionBuilder builder = new EdgeDescriptionBuilder().setDirection(EdgeDirection.OUTGOING).setEdgeType(edgeType);
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addIngoingEdge(String edgeType) {
        EdgeDescriptionBuilder builder = new EdgeDescriptionBuilder().setDirection(EdgeDirection.INGOING).setEdgeType(edgeType);
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addAttributeByType(String attributeStructureType, String attributeName) {
        AbstractAttributeDescriptionBuilder builder = this.immutableSupportingSpecificBuilders.stream().filter(AbstractAttributeDescriptionBuilder.class::isInstance).map(AbstractAttributeDescriptionBuilder.class::cast).filter(bldr -> bldr.getSupportedStructureTypeId().equals(attributeStructureType)).findAny().orElseThrow(() -> new RuntimeException("No supporting builder for attribute structure type '" + attributeStructureType + "'.")).getCopy().setAttributeName(attributeName);
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addAttributeValueByType(String attributeDataType) {
        AbstractAttributeValueDescriptionBuilder builder = this.immutableSupportingSpecificBuilders.stream().filter(AbstractAttributeValueDescriptionBuilder.class::isInstance).map(AbstractAttributeValueDescriptionBuilder.class::cast).filter(bldr -> bldr.getSupportedDataTypeId().equals(attributeDataType)).findAny().orElseThrow(() -> new RuntimeException("No supporting builder for attribute value data type '" + attributeDataType + "'.")).getCopy();
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addQueryAttribute(String attributeName) {
        AttributeQueryDescriptionBuilder builder = new AttributeQueryDescriptionBuilder();
        builder.setAttributeName(attributeName);
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addLeafAttribute(String attributeName) {
        LeafAttributeDescriptionBuilder builder = new LeafAttributeDescriptionBuilder();
        builder.setAttributeName(attributeName);
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addListAttribute(String attributeName) {
        ListAttributeDescriptionBuilder builder = new ListAttributeDescriptionBuilder();
        builder.setAttributeName(attributeName);
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addSetAttribute(String attributeName) {
        SetAttributeDescriptionBuilder builder = new SetAttributeDescriptionBuilder();
        builder.setAttributeName(attributeName);
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addStringAttributeValue() {
        StringAttributeValueDescriptionBuilder builder = new StringAttributeValueDescriptionBuilder();
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder setParent(GraphDescriptionBuilder parent) {
        this.parent = parent;
        return this;
    }

    public GraphDescriptionBuilder addUriAttributeValue() {
        UriAttributeValueDescriptionBuilder builder = new UriAttributeValueDescriptionBuilder();
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addMarkdownAttributeValue() {
        MarkdownAttributeValueDescriptionBuilder builder = new MarkdownAttributeValueDescriptionBuilder();
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addCodeAttributeValue() {
        CodeAttributeValueDescriptionBuilder builder = new CodeAttributeValueDescriptionBuilder();
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addDecimalAttributeValue() {
        DecimalAttributeValueDescriptionBuilder builder = new DecimalAttributeValueDescriptionBuilder();
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addBooleanAttributeValue() {
        BooleanAttributeValueDescriptionBuilder builder = new BooleanAttributeValueDescriptionBuilder();
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addIntegerAttributeValue() {
        IntegerAttributeValueDescriptionBuilder builder = new IntegerAttributeValueDescriptionBuilder();
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addUnsignedIntegerAttributeValue() {
        UnsignedIntegerAttributeValueDescriptionBuilder builder = new UnsignedIntegerAttributeValueDescriptionBuilder();
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addInterfaceDescription(String interfaceId) {
        AbstractPositiveDescriptionBuilder builder = new InterfaceDescriptionBuilder().setInterfaceId(interfaceId);
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addUuidDescription() {
        UuidSpecificDescriptionBuilder builder = new UuidSpecificDescriptionBuilder();
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addConstantDescription(Object value) {
        if (!Classifier.isPrimitiveOrString((Object)value) && !(value instanceof List)) {
            throw GraphDescriptionBuilderException.becauseProvidedValueIsNotPrimitiveType(value);
        }
        ConstantSpecificDescriptionBuilder builder = new ConstantSpecificDescriptionBuilder().setValue(value);
        this.addGraphDescriptionBuilder(builder);
        return this;
    }

    public GraphDescriptionBuilder addRemovalNodeDescription(String nodeType) {
        RemovalNodeDescriptionBuilder builder = new RemovalNodeDescriptionBuilder().setNodeType(nodeType);
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addRemovalEdgeDescription(String edgeType) {
        RemovalEdgeDescriptionBuilder builder = new RemovalEdgeDescriptionBuilder().setEdgeType(edgeType);
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder addReferenceDescription(String structureSerializationType) {
        ReferenceDescriptionBuilder builder = new ReferenceDescriptionBuilder().setStructureSerializationType(structureSerializationType);
        return this.addGraphDescriptionBuilder(builder);
    }

    public GraphDescriptionBuilder createNewBranch() {
        GraphDescriptionBuilder newBranch = new GraphDescriptionBuilder(this);
        this.childBranches.add(newBranch);
        return newBranch;
    }

    public GraphDescriptionBuilder addNewBranch(GraphDescriptionBuilder child) {
        child.setParent(this);
        this.childBranches.add(child);
        return child;
    }

    public GraphDescriptionBuilder addBuilderCopyOfGraphDescriptionWithNoChildrenToBuilder(GraphDescription graphDescription) {
        SpecificGraphDescriptionBuilder builder = this.getRepresentingBuilder(graphDescription);
        builder.setValues(graphDescription);
        return this.addGraphDescriptionBuilder(builder);
    }

    public SpecificGraphDescriptionBuilder convertToGraphDescriptionBuilderComposite(GraphDescription graphDescription) {
        SpecificGraphDescriptionBuilder builder = this.getRepresentingBuilder(graphDescription);
        builder.setValues(graphDescription);
        if (graphDescription.getChildGraphDescriptions().size() > 0) {
            ArrayList children = graphDescription.getChildGraphDescriptions().stream().map(this::convertToGraphDescriptionBuilderComposite).collect(Collectors.toCollection(ArrayList::new));
            builder.setChildren(children);
        }
        return builder;
    }

    public PositiveGraphDescription getOnlyPositiveGraphDescriptions() {
        GraphDescriptionBuilder builderCopy = this.copyBuilder();
        this.removeSpecificBuilderChildReferencesToRemovalBuilders(builderCopy);
        return (PositiveGraphDescription)builderCopy.build();
    }

    public List<RemovalGraphDescription> getOnlyRemovalGraphDescriptions() {
        ArrayList<AbstractRemovalDescriptionBuilder> removalBuilders = new ArrayList<AbstractRemovalDescriptionBuilder>();
        this.getAllRemovalDescriptions(this, removalBuilders);
        return removalBuilders.stream().map(AbstractRemovalDescriptionBuilder::build).collect(Collectors.toCollection(ArrayList::new));
    }

    public GraphDescriptionBuilder copyBuilder() {
        return this.copyBuilder(new GraphDescriptionBuilder());
    }

    public GraphDescription build() {
        GraphDescriptionBuilder currentBuilder = this;
        while (currentBuilder.getParent() != null) {
            currentBuilder = currentBuilder.getParent();
        }
        if (currentBuilder.descriptionBuilder == null) {
            throw GraphDescriptionBuilderException.becauseThereAreNoBuilders();
        }
        return currentBuilder.descriptionBuilder.build();
    }

    public SpecificGraphDescriptionBuilder getLastDescriptionBuilder() {
        if (this.descriptionBuilder != null) {
            return this.descriptionBuilder;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getLastDescriptionBuilder();
    }

    public SpecificGraphDescriptionBuilder getLastDescriptionBuilderOfType(Class<? extends SpecificGraphDescriptionBuilder> builderType) {
        if (this.descriptionBuilder != null && this.descriptionBuilder.getClass().equals(builderType)) {
            return this.descriptionBuilder;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getLastDescriptionBuilderOfType(builderType);
    }

    public GraphDescriptionBuilder getLastBranchWithGraphElementBuilder() {
        GraphDescriptionBuilder current = this;
        while (!(current.getDescriptionBuilder() instanceof NodeDescriptionBuilder || current.getDescriptionBuilder() instanceof EdgeDescriptionBuilder || current.getDescriptionBuilder() instanceof RemovalEdgeDescriptionBuilder || current.getDescriptionBuilder() instanceof RemovalNodeDescriptionBuilder)) {
            if ((current = current.getParent()) != null) continue;
            throw GraphDescriptionBuilderException.becauseThereAreNoGraphElementsBuilders();
        }
        return current;
    }

    public GraphDescriptionBuilder getLastBranchWithGraphBuilderOfType(Class<? extends SpecificGraphDescriptionBuilder> builderType) {
        if (this.descriptionBuilder.getClass().equals(builderType)) {
            return this;
        }
        if (this.parent == null) {
            throw GraphDescriptionBuilderException.becauseThereAreNoGraphBuildersWithGivenType(builderType);
        }
        return this.parent.getLastBranchWithGraphBuilderOfType(builderType);
    }

    private void removeSpecificBuilderChildReferencesToRemovalBuilders(GraphDescriptionBuilder builder) {
        SpecificGraphDescriptionBuilder parentSpecificBuilder;
        SpecificGraphDescriptionBuilder localSpecificBuilder = builder.getDescriptionBuilder();
        ArrayList positiveChildrenList = localSpecificBuilder.getChildren().stream().filter(child -> !(child instanceof AbstractRemovalDescriptionBuilder)).collect(Collectors.toCollection(ArrayList::new));
        localSpecificBuilder.setChildren(positiveChildrenList);
        if (localSpecificBuilder instanceof AbstractRemovalDescriptionBuilder) {
            if (builder.getParent() == null) {
                throw GraphDescriptionBuilderException.becauseFirstGraphDescriptionIsForRemoval(localSpecificBuilder);
            }
            builder.getChildBranches().forEach(this::removeSpecificBuilderChildReferencesToRemovalBuilders);
            return;
        }
        if (builder.getParent() != null && (parentSpecificBuilder = builder.getParent().getDescriptionBuilder()) instanceof AbstractRemovalDescriptionBuilder && localSpecificBuilder instanceof AbstractPositiveDescriptionBuilder && !(localSpecificBuilder instanceof UuidSpecificDescriptionBuilder)) {
            builder.getLastBranchWithGraphBuilderOfType(AbstractPositiveDescriptionBuilder.class).getDescriptionBuilder().addChild(localSpecificBuilder);
        }
        builder.getChildBranches().forEach(this::removeSpecificBuilderChildReferencesToRemovalBuilders);
    }

    private GraphDescriptionBuilder copyBuilder(GraphDescriptionBuilder parentBuilder) {
        GraphDescription graphDescription = this.descriptionBuilder.build();
        GraphDescriptionBuilder newParent = parentBuilder.addBuilderCopyOfGraphDescriptionWithNoChildrenToBuilder(graphDescription);
        this.childBranches.forEach(child -> child.copyBuilder(newParent));
        return parentBuilder;
    }

    private SpecificGraphDescriptionBuilder getRepresentingBuilder(GraphDescription graphDescription) {
        ArrayList representingBuilder = this.immutableSupportingSpecificBuilders.stream().filter(builder -> builder.represents(graphDescription)).collect(Collectors.toCollection(ArrayList::new));
        switch (representingBuilder.size()) {
            case 0: {
                throw GraphDescriptionBuilderException.becauseDescriptionTypeIsNotSupported(graphDescription);
            }
            case 1: {
                return ((SpecificGraphDescriptionBuilder)representingBuilder.get(0)).getCopy();
            }
        }
        throw GraphDescriptionBuilderException.becauseDescriptionTypeIsSupportedByMultipleBuilders(graphDescription);
    }

    private void getAllRemovalDescriptions(GraphDescriptionBuilder builder, List<AbstractRemovalDescriptionBuilder> builders) {
        SpecificGraphDescriptionBuilder specificGraphDescriptionBuilder = builder.descriptionBuilder;
        if (specificGraphDescriptionBuilder instanceof AbstractRemovalDescriptionBuilder) {
            AbstractRemovalDescriptionBuilder removalDescriptionBuilder = (AbstractRemovalDescriptionBuilder)specificGraphDescriptionBuilder;
            builders.add(removalDescriptionBuilder);
        }
        builder.getChildBranches().forEach(child -> this.getAllRemovalDescriptions((GraphDescriptionBuilder)child, builders));
    }

    private GraphDescriptionBuilder addGraphDescriptionBuilder(SpecificGraphDescriptionBuilder builder) {
        SpecificGraphDescriptionBuilder lastBuilder = this.getLastDescriptionBuilder();
        if (lastBuilder != null) {
            lastBuilder.addChild(builder);
        }
        if (this.descriptionBuilder == null) {
            this.descriptionBuilder = builder;
            return this;
        }
        GraphDescriptionBuilder newBranch = this.createNewBranch();
        newBranch.descriptionBuilder = builder;
        return newBranch;
    }

    public List<GraphDescriptionBuilder> getChildBranches() {
        return this.childBranches;
    }

    public GraphDescriptionBuilder getParent() {
        return this.parent;
    }

    public SpecificGraphDescriptionBuilder getDescriptionBuilder() {
        return this.descriptionBuilder;
    }

    private static boolean isInstanceOfUuidIdentityOrAttributeDescription(GraphDescription graphDescription) {
        if (graphDescription instanceof AbstractAttributeDescription) {
            return true;
        }
        return graphDescription instanceof UuidIdentityDescription;
    }
}

