/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder;

import ai.stapi.graphoperations.declaration.Declaration;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.GraphDescriptionBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.ListObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.MapObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.exception.GenericOGMBuilderException;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.SpecificObjectGraphMappingBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.InterfaceGraphMappingBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.LeafGraphMappingBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.ListGraphMappingBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.MapGraphMappingBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.ObjectGraphMappingBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.ReferenceGraphMappingBuilder;
import java.util.ArrayList;
import java.util.List;

public class GenericOGMBuilder {
    private final List<SpecificObjectGraphMappingBuilder> supportingBuilders = new ArrayList<SpecificObjectGraphMappingBuilder>();

    public GenericOGMBuilder() {
        this.initializeBuilders();
    }

    private void initializeBuilders() {
        this.supportingBuilders.add(new ObjectGraphMappingBuilder());
        this.supportingBuilders.add(new ListGraphMappingBuilder());
        this.supportingBuilders.add(new MapGraphMappingBuilder());
        this.supportingBuilders.add(new LeafGraphMappingBuilder());
        this.supportingBuilders.add(new InterfaceGraphMappingBuilder());
        this.supportingBuilders.add(new ReferenceGraphMappingBuilder());
    }

    public static GraphDescription getCompositeGraphDescriptionFromOgm(ObjectGraphMapping objectGraphMapping) {
        ArrayList<GraphDescription> newChildren = new ArrayList<GraphDescription>();
        if (objectGraphMapping instanceof ListObjectGraphMapping) {
            ListObjectGraphMapping list = (ListObjectGraphMapping)objectGraphMapping;
            newChildren.add(GenericOGMBuilder.getCompositeGraphDescriptionFromOgm(list.getChildObjectGraphMapping()));
        } else if (objectGraphMapping instanceof MapObjectGraphMapping) {
            MapObjectGraphMapping map = (MapObjectGraphMapping)objectGraphMapping;
            newChildren.add(GenericOGMBuilder.getCompositeGraphDescriptionFromOgm(map.getValueObjectGraphMapping()));
        } else if (objectGraphMapping instanceof ObjectObjectGraphMapping) {
            ObjectObjectGraphMapping object = (ObjectObjectGraphMapping)objectGraphMapping;
            object.getFields().values().stream().map(field -> {
                GraphDescription newChild = GenericOGMBuilder.getCompositeGraphDescriptionFromOgm(field.getFieldObjectGraphMapping());
                Declaration patt2813$temp = field.getRelation();
                if (patt2813$temp instanceof GraphDescription) {
                    GraphDescription relationDescription = (GraphDescription)patt2813$temp;
                    return new GraphDescriptionBuilder().addToDeepestDescription(relationDescription, List.of(newChild));
                }
                return newChild;
            }).forEach(newChildren::add);
        }
        return new GraphDescriptionBuilder().addToDeepestDescription(objectGraphMapping.getGraphDescription(), newChildren);
    }

    public ObjectGraphMappingBuilder createNewObjectGraphMapping() {
        return new ObjectGraphMappingBuilder();
    }

    public SpecificObjectGraphMappingBuilder copyGraphMappingAsBuilder(ObjectGraphMapping objectGraphMapping) {
        SpecificObjectGraphMappingBuilder builder = this.getSupportingBuilder(objectGraphMapping);
        return builder.copyObjectGraphMappingAsBuilder(objectGraphMapping, this);
    }

    public SpecificObjectGraphMappingBuilder getSupportingBuilder(ObjectGraphMapping objectGraphMapping) {
        SpecificObjectGraphMappingBuilder supportingBuilder = this.supportingBuilders.stream().filter(builder -> builder.supports(objectGraphMapping)).findAny().orElseThrow(() -> GenericOGMBuilderException.becauseThereIsNoSupportingBuilder(objectGraphMapping));
        return supportingBuilder.getEmptyCopy();
    }
}

