/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.objectGraphMapper.model.specific;

import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.GraphDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractAttributeValueDescription;
import ai.stapi.graphoperations.objectGraphLanguage.LeafObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.ListObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphMapper.model.GenericObjectGraphMapper;
import ai.stapi.graphoperations.objectGraphMapper.model.MissingFieldResolvingStrategy;
import ai.stapi.graphoperations.objectGraphMapper.model.specific.AbstractSpecificObjectGraphMapper;
import ai.stapi.graphoperations.objectGraphMapper.model.specific.exceptions.SpecificObjectGraphMapperException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;

public class ListSpecificObjectGraphMapper
extends AbstractSpecificObjectGraphMapper {
    public ListSpecificObjectGraphMapper(GenericObjectGraphMapper genericGraphMapper) {
        super(genericGraphMapper);
    }

    @Override
    public GraphDescriptionBuilder createGraphDescriptionWithValues(ObjectGraphMapping objectGraphMapping, Map.Entry<String, Object> fieldEntry, GraphDescriptionBuilder builder, MissingFieldResolvingStrategy missingFieldResolvingStrategy) {
        ListObjectGraphMapping listMapping = (ListObjectGraphMapping)objectGraphMapping;
        List<Object> objectList = this.convertObjectIntoList(fieldEntry.getValue(), fieldEntry.getKey());
        ObjectGraphMapping childObjectGraphMapping = listMapping.getChildObjectGraphMapping();
        if (childObjectGraphMapping instanceof LeafObjectGraphMapping) {
            LeafObjectGraphMapping leafObjectGraphMapping = (LeafObjectGraphMapping)childObjectGraphMapping;
            GraphDescriptionBuilder resolvedListBuilderBranch = this.addGraphDescriptionCompositeToBuilder(listMapping.getGraphDescription(), builder);
            GraphDescription childDescription = leafObjectGraphMapping.getGraphDescription();
            if (childDescription instanceof AbstractAttributeValueDescription) {
                objectList.forEach(value -> {
                    GraphDescriptionBuilder leafFinishedBranch = this.addGraphDescriptionCompositeToBuilder(childDescription, resolvedListBuilderBranch);
                    leafFinishedBranch.addConstantDescription(value);
                });
                return resolvedListBuilderBranch;
            }
        }
        objectList.forEach(listObject -> {
            GraphDescriptionBuilder resolvedListBuilderBranch = this.addGraphDescriptionCompositeToBuilder(listMapping.getGraphDescription(), builder);
            this.genericGraphMapper.resolveInternally(childObjectGraphMapping, Map.entry("", listObject), resolvedListBuilderBranch, missingFieldResolvingStrategy);
        });
        return builder;
    }

    private List<Object> convertObjectIntoList(Object object, String fieldName) {
        try {
            return (List)this.jsonObjectMapper.convertValue(object, (TypeReference)new TypeReference<List<Object>>(){});
        }
        catch (IllegalArgumentException error) {
            throw SpecificObjectGraphMapperException.becauseObjectCouldNotBeConverted(this, fieldName, object, error);
        }
    }

    @Override
    public boolean supports(ObjectGraphMapping objectGraphMapping) {
        return objectGraphMapping instanceof ListObjectGraphMapping;
    }
}

