/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.objectGraphMapper.model.specific;

import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.GraphDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NullGraphDescription;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectFieldDefinition;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.GenericOGMBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.SpecificObjectGraphMappingBuilder;
import ai.stapi.graphoperations.objectGraphMapper.model.GenericObjectGraphMapper;
import ai.stapi.graphoperations.objectGraphMapper.model.MissingFieldResolvingStrategy;
import ai.stapi.graphoperations.objectGraphMapper.model.specific.AbstractSpecificObjectGraphMapper;
import ai.stapi.graphoperations.objectGraphMapper.model.specific.exceptions.SpecificObjectGraphMapperException;
import ai.stapi.graphoperations.objectLanguage.EntityIdentifier;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ObjectSpecificObjectGraphMapper
extends AbstractSpecificObjectGraphMapper {
    public ObjectSpecificObjectGraphMapper(GenericObjectGraphMapper genericGraphMapper) {
        super(genericGraphMapper);
    }

    @Override
    public GraphDescriptionBuilder createGraphDescriptionWithValues(ObjectGraphMapping objectGraphMapping, Map.Entry<String, Object> fieldEntry, GraphDescriptionBuilder builder, MissingFieldResolvingStrategy resolvingStrategy) {
        ObjectObjectGraphMapping objectMapping = (ObjectObjectGraphMapping)objectGraphMapping;
        Map<String, Object> dtoObjectFields = this.convertObjectToFieldMap(fieldEntry.getValue(), fieldEntry.getKey());
        if (this.isObjectMissingAnyOfDefinedFields(dtoObjectFields, objectMapping.getFields(), resolvingStrategy)) {
            throw SpecificObjectGraphMapperException.becauseProvidedObjectDoesNotContainFieldWithGivenName(fieldEntry.getValue(), objectMapping.getFields().keySet().stream().filter(key -> !dtoObjectFields.containsKey(key)).findAny().orElseThrow(), objectMapping.getFields());
        }
        Optional<Map.Entry<String, ObjectFieldDefinition>> identifyingField = this.getEntityIdentifyingField(objectMapping, dtoObjectFields, resolvingStrategy);
        if (identifyingField.isPresent()) {
            if (builder.getDescriptionBuilder() != null) {
                builder = builder.createNewBranch();
            }
            this.resolveIdentifyingField(identifyingField.get().getValue().getFieldObjectGraphMapping(), dtoObjectFields.get(identifyingField.get().getKey()), identifyingField.get().getKey(), builder, resolvingStrategy);
        }
        GraphDescriptionBuilder finishedObjectBuilderBranch = this.addGraphDescriptionCompositeToBuilder(objectMapping.getGraphDescription(), builder);
        GraphDescriptionBuilder lastFinishedGraphElementBranch = finishedObjectBuilderBranch.getLastBranchWithGraphElementBuilder();
        objectMapping.getFields().forEach((key, field) -> {
            if (resolvingStrategy.equals((Object)MissingFieldResolvingStrategy.LENIENT) && (!dtoObjectFields.containsKey(key) || dtoObjectFields.get(key) == null)) {
                return;
            }
            if (!(field.getRelation() instanceof EntityIdentifier)) {
                ObjectFieldDefinition newField = this.copyFieldAndPushDeclarationToChild((ObjectFieldDefinition)((Object)field));
                this.genericGraphMapper.resolveInternally(newField.getFieldObjectGraphMapping(), Map.entry(key, dtoObjectFields.get(key)), lastFinishedGraphElementBranch, resolvingStrategy);
            }
        });
        return builder;
    }

    @Override
    public boolean supports(ObjectGraphMapping objectGraphMapping) {
        return objectGraphMapping instanceof ObjectObjectGraphMapping;
    }

    private void resolveIdentifyingField(ObjectGraphMapping graphMapping, Object object, String parentFieldName, GraphDescriptionBuilder builder, MissingFieldResolvingStrategy missingFieldResolvingStrategy) {
        if (graphMapping instanceof ObjectObjectGraphMapping) {
            ObjectObjectGraphMapping objectGraphMapping = (ObjectObjectGraphMapping)graphMapping;
            this.resolveObjectAsEntityIdentifier(objectGraphMapping, object, parentFieldName, builder, missingFieldResolvingStrategy);
        } else {
            this.genericGraphMapper.resolveInternally(graphMapping, Map.entry(parentFieldName, object), builder, missingFieldResolvingStrategy);
        }
    }

    private void resolveObjectAsEntityIdentifier(ObjectObjectGraphMapping objectGraphMapping, Object object, String parentFieldName, GraphDescriptionBuilder builder, MissingFieldResolvingStrategy missingFieldResolvingStrategy) {
        Map<String, Object> dtoObjectMap = this.convertObjectToFieldMap(object, parentFieldName);
        Optional<Map.Entry<String, ObjectFieldDefinition>> identifyingField = this.getEntityIdentifyingField(objectGraphMapping, dtoObjectMap, missingFieldResolvingStrategy);
        if (identifyingField.isEmpty()) {
            throw SpecificObjectGraphMapperException.becauseThereIsNoIdentifyingFieldOnObject(parentFieldName);
        }
        builder = this.addGraphDescriptionCompositeToBuilder(objectGraphMapping.getGraphDescription(), builder);
        Object objectIdentifyingField = dtoObjectMap.get(identifyingField.get().getKey());
        this.resolveIdentifyingField(identifyingField.get().getValue().getFieldObjectGraphMapping(), objectIdentifyingField, identifyingField.get().getKey(), builder, missingFieldResolvingStrategy);
    }

    private Optional<Map.Entry<String, ObjectFieldDefinition>> getEntityIdentifyingField(ObjectObjectGraphMapping objectGraphMapping, Map<String, Object> dtoObjectMap, MissingFieldResolvingStrategy resolvingStrategy) {
        List<Map.Entry> fieldEntries = objectGraphMapping.getFields().entrySet().stream().filter(entry -> ((ObjectFieldDefinition)((Object)((Object)entry.getValue()))).getRelation() instanceof EntityIdentifier).toList();
        if (fieldEntries.size() > 1) {
            throw SpecificObjectGraphMapperException.becauseThereAreMultipleIdentifyingFieldsOnObject();
        }
        if (fieldEntries.isEmpty()) {
            return Optional.empty();
        }
        if (resolvingStrategy.equals((Object)MissingFieldResolvingStrategy.LENIENT) && !dtoObjectMap.containsKey(fieldEntries.get(0).getKey())) {
            return Optional.empty();
        }
        return Optional.of(fieldEntries.get(0));
    }

    private Map<String, Object> convertObjectToFieldMap(Object object, String fieldName) {
        try {
            return (Map)this.jsonObjectMapper.convertValue(object, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IllegalArgumentException error) {
            throw SpecificObjectGraphMapperException.becauseObjectCouldNotBeConverted(this, fieldName, object, error);
        }
    }

    private boolean isObjectMissingAnyOfDefinedFields(Map<String, Object> objectFieldMap, Map<String, ObjectFieldDefinition> mappingFieldDefinition, MissingFieldResolvingStrategy strategy) {
        if (strategy.equals((Object)MissingFieldResolvingStrategy.LENIENT)) {
            return false;
        }
        return mappingFieldDefinition.keySet().stream().anyMatch(key -> !objectFieldMap.containsKey(key));
    }

    private ObjectFieldDefinition copyFieldAndPushDeclarationToChild(ObjectFieldDefinition fieldDefinition) {
        if (!(fieldDefinition.getRelation() instanceof GraphDescription)) {
            return fieldDefinition;
        }
        if (fieldDefinition.getRelation() instanceof NullGraphDescription) {
            return fieldDefinition;
        }
        GraphDescriptionBuilder builder = new GraphDescriptionBuilder();
        GraphDescription childDescription = fieldDefinition.getFieldObjectGraphMapping().getGraphDescription();
        GraphDescription combinedDescription = builder.copyWithNewChildren((GraphDescription)fieldDefinition.getRelation(), childDescription);
        GenericOGMBuilder genericBuilder = new GenericOGMBuilder();
        SpecificObjectGraphMappingBuilder newChild = genericBuilder.copyGraphMappingAsBuilder(fieldDefinition.getFieldObjectGraphMapping());
        newChild.setNewGraphDescription(combinedDescription);
        return new ObjectFieldDefinition(new NullGraphDescription(), newChild.build());
    }
}

