/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.aggregatedefinition.model.eventFactory;

import ai.stapi.graphsystem.aggregatedefinition.model.CommandHandlerDefinitionDTO;
import ai.stapi.graphsystem.aggregatedefinition.model.eventFactory.EventFactoryModificationResult;
import ai.stapi.graphsystem.aggregatedefinition.model.eventFactory.OperationEventFactoriesMapper;
import ai.stapi.graphsystem.eventdefinition.EventMessageDefinitionData;
import ai.stapi.graphsystem.operationdefinition.model.FieldDefinitionWithSource;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionStructureTypeMapper;
import ai.stapi.graphsystem.operationdefinition.model.resourceStructureTypeOperationsMapper.OperationDefinitionParameters;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structuredefinition.StructureDefinitionId;
import java.util.List;

public class ItemAddedOperationEventFactoriesMapper
implements OperationEventFactoriesMapper {
    private final OperationDefinitionStructureTypeMapper mapper;

    public ItemAddedOperationEventFactoriesMapper(OperationDefinitionStructureTypeMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public List<CommandHandlerDefinitionDTO.EventFactory> map(OperationDefinitionDTO operationDefinition) {
        String resourceName = operationDefinition.getResource().get(0);
        String itemAddedEventId = this.createItemAddedEventId(operationDefinition.getId());
        String itemAddedEventName = this.createItemAddedEventName(operationDefinition.getId());
        ComplexStructureType fakedStructure = this.mapper.map(operationDefinition);
        return List.of(new CommandHandlerDefinitionDTO.EventFactory(new EventMessageDefinitionData(itemAddedEventId, itemAddedEventName, new StructureDefinitionId(resourceName), "Generated Event for adding on " + resourceName + "."), fakedStructure.getAllFields().values().stream().map(FieldDefinitionWithSource.class::cast).filter(field -> !field.getLastSourcePath().equals("id")).map((? super T fieldDefinition) -> this.createModification(fieldDefinition.getSource(), fieldDefinition.getName())).toList()));
    }

    @Override
    public List<EventFactoryModificationResult> mapParameters(OperationDefinitionParameters operationDefinitionParameters) {
        return List.of();
    }

    private CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification createModification(String sourcePath, String parameterName) {
        return CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification.add(sourcePath, parameterName);
    }

    private String createItemAddedEventId(String operationName) {
        String prefix = "Add";
        String suffix = "Added";
        if (operationName.startsWith(prefix)) {
            return operationName.substring(prefix.length()) + suffix;
        }
        return operationName + suffix;
    }

    private String createItemAddedEventName(String operationName) {
        String prefix = "Add";
        String suffix = "Added";
        String substring = operationName;
        if (operationName.startsWith(prefix)) {
            substring = operationName.substring(prefix.length());
        }
        CharSequence[] parts = substring.split("On");
        return String.format("%s %s", String.join((CharSequence)" on ", parts), suffix);
    }
}

