/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.commandvalidation.model;

import ai.stapi.graphsystem.commandvalidation.model.CommandConstrainViolation;
import ai.stapi.graphsystem.commandvalidation.model.fieldPath.CommandViolationFieldPath;

public abstract class AbstractCommandConstrainViolation
implements CommandConstrainViolation {
    private final String commandName;
    private final CommandViolationFieldPath fieldPath;
    private final CommandConstrainViolation.Level level;

    protected AbstractCommandConstrainViolation(String commandName, CommandViolationFieldPath fieldPath, CommandConstrainViolation.Level level) {
        this.commandName = commandName;
        this.fieldPath = fieldPath;
        this.level = level;
    }

    protected abstract String getBecauseMessage();

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public CommandViolationFieldPath getFieldPath() {
        return this.fieldPath;
    }

    @Override
    public String getMessage() {
        return String.format("[%s] Command with name: '%s' did not validate.\nField path: %s\n%s", new Object[]{this.level, this.commandName, this.renderFieldPath(), this.getBecauseMessage()});
    }

    @Override
    public CommandConstrainViolation.Level getLevel() {
        return this.level;
    }

    private String renderFieldPath() {
        return this.commandName + this.fieldPath.renderPath();
    }
}

