/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.commandvalidation.infrastructure.operationdefinition;

import ai.stapi.graphsystem.commandvalidation.model.AbstractCommandConstrainViolation;
import ai.stapi.graphsystem.commandvalidation.model.CommandConstrainViolation;
import ai.stapi.graphsystem.commandvalidation.model.fieldPath.CommandViolationFieldPath;
import java.util.List;

public class InvalidUnionMemberTypeCommandViolation
extends AbstractCommandConstrainViolation {
    private final Object actualMemberType;
    private final List<String> possibleMemberTypes;

    public InvalidUnionMemberTypeCommandViolation(String commandName, CommandViolationFieldPath fieldPath, Object actualMemberType, List<String> possibleMemberTypes) {
        super(commandName, fieldPath, CommandConstrainViolation.Level.ERROR);
        this.actualMemberType = actualMemberType;
        this.possibleMemberTypes = possibleMemberTypes;
    }

    @Override
    protected String getBecauseMessage() {
        String message = "Union member type is not allowed in union. Actual member type: %s\nPossible member types: %s";
        return String.format(message, this.actualMemberType, this.possibleMemberTypes);
    }

    public Object getActualMemberType() {
        return this.actualMemberType;
    }

    public List<String> getPossibleMemberTypes() {
        return this.possibleMemberTypes;
    }
}

