/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.fixtures.fixtureCommandsGenerator;

import ai.stapi.graphsystem.fixtures.fixtureCommandsGenerator.CommandDefinition;
import ai.stapi.graphsystem.fixtures.fixtureCommandsGenerator.FixtureCommandsGenerator;
import ai.stapi.graphsystem.messaging.command.Command;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FixtureCommandsGeneratorResult
implements Serializable {
    private String generatorClassName;
    private List<CommandDefinition> commandDefinitions;
    private boolean oneTimeGenerator = false;
    private Set<String> processedFiles;

    private FixtureCommandsGeneratorResult() {
    }

    public FixtureCommandsGeneratorResult(Class<? extends FixtureCommandsGenerator> generatorClassName, List<Command> commands) {
        this.generatorClassName = generatorClassName.getName();
        this.commandDefinitions = commands.stream().map(CommandDefinition::new).collect(Collectors.toList());
        this.processedFiles = new HashSet<String>();
        this.oneTimeGenerator = true;
    }

    public FixtureCommandsGeneratorResult(Class<? extends FixtureCommandsGenerator> generatorClassName, List<Command> commands, Set<String> processedFiles) {
        this.generatorClassName = generatorClassName.getName();
        this.commandDefinitions = commands.stream().map(CommandDefinition::new).collect(Collectors.toList());
        this.processedFiles = processedFiles;
        this.oneTimeGenerator = false;
    }

    public String getGeneratorClassName() {
        return this.generatorClassName;
    }

    @JsonIgnore
    public List<Command> getCommands() {
        return this.commandDefinitions.stream().map(CommandDefinition::getCommand).collect(Collectors.toList());
    }

    public List<CommandDefinition> getCommandDefinitions() {
        return this.commandDefinitions;
    }

    public boolean isOneTimeGenerator() {
        return this.oneTimeGenerator;
    }

    public Set<String> getProcessedFiles() {
        return this.processedFiles;
    }
}

