/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.operationdefinition.model.resourceStructureTypeOperationsMapper;

import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.graphsystem.operationdefinition.model.resourceStructureTypeOperationsMapper.AbstractResourceOperationsMapper;
import ai.stapi.graphsystem.operationdefinition.model.resourceStructureTypeOperationsMapper.OperationDefinitionParameters;
import ai.stapi.graphsystem.operationdefinition.model.resourceStructureTypeOperationsMapper.ResourceOperationsMapperResult;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.ResourceStructureType;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CreationalResourceOperationMapper
extends AbstractResourceOperationsMapper {
    public CreationalResourceOperationMapper(StructureSchemaFinder structureSchemaFinder) {
        super(structureSchemaFinder);
    }

    @Override
    public ResourceOperationsMapperResult map(ResourceStructureType resourceStructureType) {
        if (resourceStructureType.isAbstract()) {
            return new ResourceOperationsMapperResult();
        }
        String resourceName = resourceStructureType.getDefinitionType();
        String createCommandId = this.createCreateCommandId(resourceName);
        String createCommandName = this.createCreateCommandName(resourceName);
        return new ResourceOperationsMapperResult(new OperationDefinitionDTO(createCommandId, createCommandName, "draft", "operation", "Generated command for creating " + resourceName + " with all fields.", createCommandName, List.of(resourceName), false, true, true, this.createParameters(resourceStructureType)));
    }

    @Override
    public ResourceOperationsMapperResult mapNewFields(ResourceStructureType rootResourceType, ComplexStructureType modifiedStructureType, List<String> newFieldNames) {
        String modifiedType;
        if (rootResourceType.isAbstract()) {
            return new ResourceOperationsMapperResult();
        }
        String rootType = rootResourceType.getDefinitionType();
        if (!this.structureSchemaFinder.isEqualOrInherits(rootType, modifiedType = modifiedStructureType.getDefinitionType())) {
            return new ResourceOperationsMapperResult();
        }
        return newFieldNames.stream().map((? super T fieldName) -> {
            FieldDefinition newField = rootResourceType.getField(fieldName);
            if (newField.getName().equals("id")) {
                return new ResourceOperationsMapperResult();
            }
            String definitionType = rootResourceType.getDefinitionType();
            String commandId = this.createCreateCommandId(definitionType);
            return new ResourceOperationsMapperResult(new OperationDefinitionParameters(commandId, this.createParametersForField(definitionType, newField).toList()));
        }).reduce(ResourceOperationsMapperResult::merge).orElse(new ResourceOperationsMapperResult());
    }

    @NotNull
    private List<OperationDefinitionDTO.ParameterDTO> createParameters(ResourceStructureType resourceStructureType) {
        String definitionType = resourceStructureType.getDefinitionType();
        return resourceStructureType.getAllFields().values().stream().filter(field -> !field.getName().equals("id")).flatMap(field -> this.createParametersForField(definitionType, (FieldDefinition)field)).toList();
    }

    private Stream<OperationDefinitionDTO.ParameterDTO> createParametersForField(String definitionType, FieldDefinition field) {
        String generatedPath = String.format("%s.%s", definitionType, field.getName());
        return this.createFieldParameters(generatedPath, field).stream();
    }

    private String createCreateCommandId(String resourceType) {
        return "Create" + resourceType;
    }

    private String createCreateCommandName(String resourceType) {
        return "Create " + resourceType;
    }
}

