/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.aggregatedefinition.model;

import ai.stapi.graphsystem.eventdefinition.EventMessageDefinitionData;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class CommandHandlerDefinitionDTO {
    private OperationDefinitionDTO operation;
    private String creationalPolicy;
    private List<EventFactory> eventFactory;

    private CommandHandlerDefinitionDTO() {
    }

    public CommandHandlerDefinitionDTO(OperationDefinitionDTO operation, String creationalPolicy, List<EventFactory> eventFactory) {
        this.operation = operation;
        this.creationalPolicy = creationalPolicy;
        this.eventFactory = eventFactory;
    }

    public OperationDefinitionDTO getOperation() {
        return this.operation;
    }

    public String getCreationalPolicy() {
        return this.creationalPolicy;
    }

    public List<EventFactory> getEventFactory() {
        return this.eventFactory;
    }

    public static class CreationPolicy {
        public static final String ALWAYS = "always";
        public static final String NEVER = "never";
        public static final String IF_MISSING = "if_missing";

        private CreationPolicy() {
        }
    }

    public static class EventFactory {
        private String id;
        private EventMessageDefinitionData event;
        private List<EventFactoryModification> modification;

        protected EventFactory() {
        }

        public EventFactory(String id, EventMessageDefinitionData event, List<EventFactoryModification> modification) {
            this.id = id;
            this.event = event;
            this.modification = modification;
        }

        public EventFactory(EventMessageDefinitionData event, List<EventFactoryModification> modification) {
            this(UUID.randomUUID().toString(), event, modification);
        }

        public void addModification(EventFactoryModification modification) {
            this.getModification().add(modification);
        }

        public void addModifications(List<EventFactoryModification> modifications) {
            this.getModification().addAll(this.modification);
        }

        public EventMessageDefinitionData getEvent() {
            return this.event;
        }

        public List<EventFactoryModification> getModification() {
            return this.modification;
        }

        public String getId() {
            return this.id;
        }

        public static class EventFactoryModification {
            public static final String ADD = "add";
            public static final String REPLACE = "replace";
            public static final String REMOVE = "remove";
            public static final String INSERT = "insert";
            public static final String MOVE = "move";
            private String kind;
            private String modificationPath;
            @Nullable
            private String inputValueParameterName;
            @Nullable
            private String destinationIndexParameterName;

            private EventFactoryModification() {
            }

            private EventFactoryModification(String kind, String modificationPath, @Nullable String inputValueParameterName, @Nullable String destinationIndexParameterName) {
                this.kind = kind;
                this.modificationPath = modificationPath;
                this.inputValueParameterName = inputValueParameterName;
                this.destinationIndexParameterName = destinationIndexParameterName;
            }

            public static EventFactoryModification add(String modificationPath, @Nullable String inputValueParameterName) {
                return new EventFactoryModification(ADD, modificationPath, inputValueParameterName, null);
            }

            public static EventFactoryModification replace(String modificationPath, @Nullable String inputValueParameterName) {
                return new EventFactoryModification(REPLACE, modificationPath, inputValueParameterName, null);
            }

            public static EventFactoryModification remove(String modificationPath, @Nullable String inputValueParameterName) {
                return new EventFactoryModification(REMOVE, modificationPath, inputValueParameterName, null);
            }

            public static EventFactoryModification insert(String modificationPath, @Nullable String inputValueParameterName, @Nullable String destinationIndexParameterName) {
                return new EventFactoryModification(INSERT, modificationPath, inputValueParameterName, destinationIndexParameterName);
            }

            public static EventFactoryModification move(String modificationPath, @Nullable String inputValueParameterName, @Nullable String destinationIndexParameterName) {
                return new EventFactoryModification(MOVE, modificationPath, inputValueParameterName, destinationIndexParameterName);
            }

            public String getKind() {
                return this.kind;
            }

            public String getModificationPath() {
                return this.modificationPath;
            }

            @Nullable
            public String getInputValueParameterName() {
                return this.inputValueParameterName;
            }

            @Nullable
            public String getDestinationIndexParameterName() {
                return this.destinationIndexParameterName;
            }
        }
    }
}

