/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.operationdefinition.model;

import ai.stapi.graphsystem.operationdefinition.exceptions.CannotMapOperationDefinitionToStructureType;
import ai.stapi.graphsystem.operationdefinition.model.FieldDefinitionWithSource;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchema.PrimitiveStructureType;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaProvider;
import ai.stapi.schema.structureSchemaProvider.exception.CannotProvideStructureSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class OperationDefinitionStructureTypeMapper {
    private final StructureSchemaProvider structureSchemaProvider;

    public OperationDefinitionStructureTypeMapper(StructureSchemaProvider structureSchemaProvider) {
        this.structureSchemaProvider = structureSchemaProvider;
    }

    public List<ComplexStructureType> map(List<OperationDefinitionDTO> operationDefinitions) {
        return operationDefinitions.stream().map(this::map).toList();
    }

    public ComplexStructureType map(OperationDefinitionDTO operationDefinition) {
        String operationName = operationDefinition.getId();
        Map<String, List<OperationDefinitionDTO.ParameterDTO>> parameterGroups = this.createParameterGroups(operationDefinition);
        HashMap fakeFields = new HashMap();
        parameterGroups.forEach((fieldName, parameters) -> {
            OperationDefinitionDTO.ParameterDTO anyParameter = (OperationDefinitionDTO.ParameterDTO)parameters.get(0);
            String finalFieldName = parameters.size() == 1 ? anyParameter.getName() : fieldName;
            FieldDefinitionWithSource fakeField = new FieldDefinitionWithSource(finalFieldName, anyParameter.getMin(), anyParameter.getMax(), "", parameters.stream().flatMap(parameter -> this.fakeFieldType(operationName, (OperationDefinitionDTO.ParameterDTO)parameter, parameters.size() > 1)).toList(), operationName, anyParameter.getSingleReferencedFrom().getSource());
            fakeFields.put(finalFieldName, fakeField);
        });
        return new ComplexStructureType(operationName, fakeFields, operationDefinition.getDescription(), null, false);
    }

    private Map<String, List<OperationDefinitionDTO.ParameterDTO>> createParameterGroups(OperationDefinitionDTO operationDefinition) {
        HashMap<String, List<OperationDefinitionDTO.ParameterDTO>> parameterGroups = new HashMap<String, List<OperationDefinitionDTO.ParameterDTO>>();
        operationDefinition.getParameter().forEach(parameter -> {
            if (!parameter.getUse().equals("in")) {
                return;
            }
            String parameterName = parameter.getName();
            String fieldName = this.createFieldName(parameterName, StringUtils.capitalize((String)parameter.getType()));
            List parameters = parameterGroups.getOrDefault(fieldName, new ArrayList());
            parameters.add(parameter);
            parameterGroups.put(fieldName, parameters);
        });
        return parameterGroups;
    }

    private String createFieldName(String parameterName, String parameterType) {
        int suffixLength = parameterType.length();
        if (parameterName.length() < suffixLength + 1) {
            return parameterName;
        }
        if (parameterName.equals(parameterType)) {
            return parameterName;
        }
        if (!parameterName.endsWith(parameterType)) {
            return parameterName;
        }
        return parameterName.substring(0, parameterName.length() - suffixLength);
    }

    @NotNull
    private Stream<FieldType> fakeFieldType(String operationName, OperationDefinitionDTO.ParameterDTO parameterDTO, boolean isInUnion) {
        AbstractStructureType structure;
        String type = parameterDTO.getType();
        if (type.equals("Reference")) {
            return parameterDTO.getTargetProfileReference().stream().map((? super T targetProfile) -> new FieldType(targetProfile.getId(), type));
        }
        try {
            structure = this.structureSchemaProvider.provideSpecific(type);
        }
        catch (CannotProvideStructureSchema e) {
            throw new CannotMapOperationDefinitionToStructureType(operationName, parameterDTO.getName(), type, e);
        }
        if (structure instanceof PrimitiveStructureType && isInUnion) {
            return Stream.of(new FieldType(String.format("Boxed%s", StringUtils.capitalize((String)type)), type));
        }
        return Stream.of(new FieldType(type, type));
    }
}

