/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.operationdefinition.model.resourceStructureTypeOperationsMapper;

import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.graphsystem.operationdefinition.model.resourceStructureTypeOperationsMapper.AbstractResourceOperationsMapper;
import ai.stapi.graphsystem.operationdefinition.model.resourceStructureTypeOperationsMapper.ResourceOperationsMapperResult;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.ResourceStructureType;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddItemOnResourceOperationsMapper
extends AbstractResourceOperationsMapper {
    public AddItemOnResourceOperationsMapper(StructureSchemaFinder structureSchemaFinder) {
        super(structureSchemaFinder);
    }

    @Override
    public ResourceOperationsMapperResult map(ResourceStructureType resourceStructureType) {
        String resourceType = resourceStructureType.getDefinitionType();
        return new ResourceOperationsMapperResult(this.createOperationsRecursively(new MapperContext(resourceType, List.of(resourceType)), (ComplexStructureType)resourceStructureType));
    }

    @Override
    public ResourceOperationsMapperResult mapNewFields(ResourceStructureType rootResourceType, ComplexStructureType modifiedStructureType, List<String> newFieldNames) {
        return newFieldNames.stream().map((? super T fieldName) -> {
            FieldDefinition newField = modifiedStructureType.getField(fieldName);
            if (newField.getName().equals("id")) {
                return new ResourceOperationsMapperResult();
            }
            String type = rootResourceType.getDefinitionType();
            MapperContext mapperContext = new MapperContext(type, List.of(type));
            return new ResourceOperationsMapperResult(this.processNewFieldOnComplexRecursively(mapperContext, (ComplexStructureType)rootResourceType, modifiedStructureType, newField));
        }).reduce(ResourceOperationsMapperResult::merge).orElse(new ResourceOperationsMapperResult());
    }

    @NotNull
    private List<OperationDefinitionDTO> createOperationsRecursively(MapperContext mapperContext, ComplexStructureType structure) {
        Map fields = structure.getOwnFields();
        List<OperationDefinitionDTO> operations = fields.values().stream().filter(FieldDefinition::isList).map((? super T fieldDefinition) -> this.createAddItemCommand(mapperContext, (FieldDefinition)fieldDefinition)).collect(Collectors.toList());
        fields.values().forEach(fieldDefinition -> operations.addAll(this.createDeeperOperations(mapperContext, (FieldDefinition)fieldDefinition)));
        return operations;
    }

    private List<OperationDefinitionDTO> processNewFieldOnComplexRecursively(MapperContext mapperContext, ComplexStructureType currentStructureType, ComplexStructureType modifiedStructureType, FieldDefinition newFieldDefinition) {
        String modifiedType;
        String currentType = currentStructureType.getDefinitionType();
        if (currentType.equals(modifiedType = modifiedStructureType.getDefinitionType())) {
            ArrayList<OperationDefinitionDTO> resultOperations = new ArrayList<OperationDefinitionDTO>();
            if (newFieldDefinition.isList()) {
                OperationDefinitionDTO newOperation = this.createAddItemCommand(mapperContext, newFieldDefinition);
                resultOperations.add(newOperation);
            }
            resultOperations.addAll(this.createDeeperOperations(mapperContext, newFieldDefinition));
            return resultOperations;
        }
        return currentStructureType.getOwnFields().values().stream().flatMap(fieldDefinition -> fieldDefinition.getTypes().stream().filter(type -> !type.isReference()).filter(type -> !type.isContentReferenced()).map((? super T type) -> this.structureSchemaFinder.getStructureType(type.getType())).filter(ComplexStructureType.class::isInstance).map(ComplexStructureType.class::cast).flatMap(type -> this.doNewFieldRecursion(mapperContext, (FieldDefinition)fieldDefinition, (ComplexStructureType)type, modifiedStructureType, newFieldDefinition).stream())).toList();
    }

    @NotNull
    private List<OperationDefinitionDTO> createDeeperOperations(MapperContext mapperContext, FieldDefinition fieldDefinition) {
        return fieldDefinition.getTypes().stream().filter(type -> !type.isReference()).filter(type -> !type.isContentReferenced()).map((? super T type) -> this.structureSchemaFinder.getStructureType(type.getType())).filter(ComplexStructureType.class::isInstance).map(ComplexStructureType.class::cast).flatMap(type -> this.doRecursion(mapperContext, fieldDefinition, (ComplexStructureType)type).stream()).collect(Collectors.groupingBy(OperationDefinitionDTO::getId)).values().stream().map((? super T grouped) -> (OperationDefinitionDTO)grouped.stream().reduce(OperationDefinitionDTO::merge).get()).toList();
    }

    private List<OperationDefinitionDTO> doRecursion(MapperContext mapperContext, FieldDefinition fieldDefinition, ComplexStructureType type) {
        MapperContext newContext = mapperContext.addPath(fieldDefinition.getName());
        if (fieldDefinition.isList()) {
            return this.createOperationsRecursively(newContext.setNewListParent(fieldDefinition.getName(), newContext.getPath()), type);
        }
        return this.createOperationsRecursively(newContext, type);
    }

    private List<OperationDefinitionDTO> doNewFieldRecursion(MapperContext mapperContext, FieldDefinition fieldDefinition, ComplexStructureType type, ComplexStructureType modifiedStructureType, FieldDefinition newFieldDefinition) {
        MapperContext newContext = mapperContext.addPath(fieldDefinition.getName());
        if (fieldDefinition.isList()) {
            return this.processNewFieldOnComplexRecursively(newContext.setNewListParent(fieldDefinition.getName(), newContext.getPath()), type, modifiedStructureType, newFieldDefinition);
        }
        return this.processNewFieldOnComplexRecursively(newContext, type, modifiedStructureType, newFieldDefinition);
    }

    private OperationDefinitionDTO createAddItemCommand(MapperContext mapperContext, FieldDefinition fieldDefinition) {
        String fieldName = fieldDefinition.getName();
        String commandId = this.createAddItemCommandId(mapperContext, fieldName);
        String commandName = this.createAddItemCommandName(mapperContext, fieldName);
        String generatedSourcePath = String.format("%s.%s", String.join((CharSequence)".", mapperContext.getPath()), fieldDefinition.getName());
        List<OperationDefinitionDTO.ParameterDTO> parameters = this.createFieldParameters(generatedSourcePath, fieldDefinition, 1, "*");
        String description = String.format("Generated command for adding %s(%s) on %s Aggregate", fieldName, parameters.stream().map(OperationDefinitionDTO.ParameterDTO::getType).collect(Collectors.joining(" | ")), mapperContext.getResourceType());
        if (mapperContext.getLastParentListPath() != null) {
            parameters = new ArrayList<OperationDefinitionDTO.ParameterDTO>(parameters);
            OperationDefinitionDTO.ParameterDTO idParameter = new OperationDefinitionDTO.ParameterDTO(String.format("%sId", mapperContext.getLastParentListName()), "in", (Integer)1, "1", "id", new OperationDefinitionDTO.ParameterDTO.ReferencedFrom(String.format("%s.id", String.join((CharSequence)".", mapperContext.getLastParentListPath()))), List.of());
            parameters.add(idParameter);
        }
        return new OperationDefinitionDTO(commandId, commandName, "draft", "operation", description, commandId, List.of(mapperContext.getResourceType()), false, false, true, parameters);
    }

    private String createAddItemCommandId(MapperContext mapperContext, String fieldName) {
        return String.format("Add%sOn%s", StringUtils.capitalize((String)fieldName), mapperContext.getPath().stream().map(StringUtils::capitalize).collect(Collectors.joining()));
    }

    private String createAddItemCommandName(MapperContext mapperContext, String fieldName) {
        return String.format("Add %s on %s", StringUtils.capitalize((String)fieldName), String.join((CharSequence)".", mapperContext.getPath()));
    }

    private static class MapperContext {
        private final String resourceType;
        private final List<String> path;
        @Nullable
        private final String lastParentListName;
        @Nullable
        private final List<String> lastParentListPath;

        public MapperContext(String resourceType, List<String> path, @Nullable String lastParentListName, @Nullable List<String> lastParentListPath) {
            this.resourceType = resourceType;
            this.path = path;
            this.lastParentListName = lastParentListName;
            this.lastParentListPath = lastParentListPath;
        }

        public MapperContext(String resourceType, List<String> path) {
            this(resourceType, path, null, null);
        }

        public MapperContext addPath(String pathPart) {
            ArrayList<String> newPath = new ArrayList<String>(this.path);
            newPath.add(pathPart);
            return new MapperContext(this.resourceType, newPath, this.lastParentListName, this.lastParentListPath);
        }

        public MapperContext setNewListParent(String lastParentListName, List<String> lastParentListPath) {
            return new MapperContext(this.resourceType, this.path, lastParentListName, lastParentListPath);
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public List<String> getPath() {
            return this.path;
        }

        @Nullable
        public String getLastParentListName() {
            return this.lastParentListName;
        }

        @Nullable
        public List<String> getLastParentListPath() {
            return this.lastParentListPath;
        }
    }
}

