/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.structuredefinition.loader;

import ai.stapi.schema.adHocLoaders.GenericAdHocModelDefinitionsLoader;
import ai.stapi.schema.scopeProvider.ScopeCacher;
import ai.stapi.schema.scopeProvider.ScopeOptions;
import ai.stapi.schema.structuredefinition.ElementDefinition;
import ai.stapi.schema.structuredefinition.RawStructureDefinitionData;
import ai.stapi.schema.structuredefinition.StructureDefinitionData;
import ai.stapi.schema.structuredefinition.StructureDefinitionNormalizer;
import ai.stapi.schema.structuredefinition.loader.StructureDefinitionLoader;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SystemAdHocStructureDefinitionLoader
implements StructureDefinitionLoader {
    private final GenericAdHocModelDefinitionsLoader genericAdHocModelDefinitionsLoader;
    private final ObjectMapper objectMapper;
    private final ScopeCacher scopeCacher;

    public SystemAdHocStructureDefinitionLoader(GenericAdHocModelDefinitionsLoader genericAdHocModelDefinitionsLoader, ObjectMapper objectMapper, ScopeCacher scopeCacher) {
        this.genericAdHocModelDefinitionsLoader = genericAdHocModelDefinitionsLoader;
        this.objectMapper = objectMapper;
        this.scopeCacher = scopeCacher;
    }

    public List<StructureDefinitionData> load() {
        return (List)this.scopeCacher.getCachedOrCompute(SystemAdHocStructureDefinitionLoader.class, this::load);
    }

    private List<StructureDefinitionData> load(ScopeOptions scopeOptions) {
        List<StructureDefinitionData> importStructure = this.genericAdHocModelDefinitionsLoader.load(scopeOptions, "ImportStructureDefinition", RawStructureDefinitionData.class).stream().map(StructureDefinitionNormalizer::normalize).toList();
        List<StructureDefinitionData> createStructure = this.genericAdHocModelDefinitionsLoader.load(scopeOptions, "CreateStructureDefinition", RawStructureDefinitionData.class).stream().map(StructureDefinitionNormalizer::normalize).toList();
        List structureDefinition = this.genericAdHocModelDefinitionsLoader.load(scopeOptions, "StructureDefinition", StructureDefinitionData.class);
        ArrayList<StructureDefinitionData> finalStructures = new ArrayList<StructureDefinitionData>(importStructure);
        finalStructures.addAll(createStructure);
        finalStructures.addAll(structureDefinition);
        List<StructureDefinitionData> addElement = this.genericAdHocModelDefinitionsLoader.load(scopeOptions, "AddElementOnStructureDefinitionDifferential").stream().map(add -> this.fixAddElement((HashMap)add, finalStructures)).toList();
        finalStructures.addAll(addElement);
        return this.sortDefinitionsByKind(finalStructures);
    }

    @NotNull
    private ArrayList<StructureDefinitionData> sortDefinitionsByKind(List<StructureDefinitionData> definitionDTOs) {
        ArrayList<StructureDefinitionData> sortedList = new ArrayList<StructureDefinitionData>();
        sortedList.addAll(definitionDTOs.stream().filter(dto -> dto.getKind().equals("primitive-type")).toList());
        sortedList.addAll(definitionDTOs.stream().filter(dto -> dto.getKind().equals("complex-type")).toList());
        sortedList.addAll(definitionDTOs.stream().filter(dto -> dto.getKind().equals("resource")).toList());
        return sortedList;
    }

    private StructureDefinitionData fixAddElement(HashMap addElementMap, ArrayList<StructureDefinitionData> finalStructures) {
        String id = (String)addElementMap.get("id");
        List<StructureDefinitionData> parentStructures = finalStructures.stream().filter(structure -> structure.getId().equals(id)).toList();
        if (parentStructures.isEmpty()) {
            throw new RuntimeException(String.format("You are trying to add ElementDefinition to StructureDefinition with id '%s'. But it cant be found in requested scope.", id));
        }
        Object element = addElementMap.get("element");
        ArrayList castedElement = (ArrayList)this.objectMapper.convertValue(element, (TypeReference)new TypeReference<ArrayList<ElementDefinition>>(){});
        StructureDefinitionData parentStructure = parentStructures.get(0);
        return new StructureDefinitionData(id, parentStructure.getUrl(), parentStructure.getStatus(), parentStructure.getDescription(), parentStructure.getKind(), parentStructure.getIsAbstract(), parentStructure.getType(), parentStructure.getBaseDefinition(), parentStructure.getBaseDefinitionReference(), (List)castedElement);
    }
}

