/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.operationdefinition.model;

import ai.stapi.graphsystem.operationdefinition.exceptions.CannotMergeOperationDefinition;
import ai.stapi.graphsystem.operationdefinition.exceptions.InvalidOperationDefinition;
import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.schema.structuredefinition.StructureDefinitionId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OperationDefinitionDTO {
    private String id;
    private String name;
    private String status;
    private String kind;
    private List<String> description;
    private String code;
    private List<String> resource;
    private boolean system;
    private boolean type;
    private boolean instance;
    private List<ParameterDTO> parameter;

    private OperationDefinitionDTO() {
    }

    public OperationDefinitionDTO(String id, String name, String status, String kind, String description, String code, List<String> resource, boolean system, boolean type, boolean instance, List<ParameterDTO> parameter) {
        this(id, name, status, kind, List.of(description), code, resource, system, type, instance, parameter);
    }

    private OperationDefinitionDTO(String id, String name, String status, String kind, List<String> description, String code, List<String> resource, boolean system, boolean type, boolean instance, List<ParameterDTO> parameter) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.kind = kind;
        this.description = description;
        this.code = code;
        this.resource = resource;
        this.system = system;
        this.type = type;
        this.instance = instance;
        this.parameter = parameter;
    }

    public static OperationDefinitionDTO bareBone(String id, List<ParameterDTO> parameter) {
        return new OperationDefinitionDTO(id, null, null, null, "", null, List.of(), false, false, false, parameter);
    }

    public void addParameters(List<ParameterDTO> parameters) {
        this.parameter.addAll(parameters);
    }

    public OperationDefinitionDTO merge(OperationDefinitionDTO other) {
        if (!Objects.equals(this.getId(), other.getId())) {
            throw CannotMergeOperationDefinition.becauseSomeFieldIsNotSame("id", this.getId(), other.getId());
        }
        if (!Objects.equals(this.getCode(), other.getCode())) {
            throw CannotMergeOperationDefinition.becauseSomeFieldIsNotSame("code", this.getCode(), other.getCode());
        }
        if (!Objects.equals(this.getName(), other.getName())) {
            throw CannotMergeOperationDefinition.becauseSomeFieldIsNotSame("name", this.getName(), other.getName());
        }
        if (!Objects.equals(this.getStatus(), other.getStatus())) {
            throw CannotMergeOperationDefinition.becauseSomeFieldIsNotSame("status", this.getStatus(), other.getStatus());
        }
        if (!Objects.equals(this.getKind(), other.getKind())) {
            throw CannotMergeOperationDefinition.becauseSomeFieldIsNotSame("kind", this.getKind(), other.getKind());
        }
        HashSet<String> mergedResources = new HashSet<String>(this.getResource());
        mergedResources.addAll(other.getResource());
        ArrayList<ParameterDTO> mergedParameters = new ArrayList<ParameterDTO>(this.getParameter());
        mergedParameters.addAll(other.getParameter());
        List<ParameterDTO> deduplicatedParams = mergedParameters.stream().collect(Collectors.groupingBy(ParameterDTO::getName)).values().stream().map(group -> group.stream().collect(Collectors.groupingBy(ParameterDTO::getType))).map(group -> group.values().stream().map(typeGroup -> (ParameterDTO)typeGroup.stream().reduce(ParameterDTO::merge).get()).toList()).flatMap(group -> {
            if (group.size() == 1) {
                return group.stream();
            }
            return group.stream().map(parameterDTO -> new ParameterDTO(String.format("%s%s", parameterDTO.getName(), StringUtils.capitalize((String)parameterDTO.getType())), parameterDTO.getUse(), parameterDTO.getMin(), parameterDTO.getMax(), parameterDTO.getType(), parameterDTO.getReferencedFrom(), parameterDTO.getTargetProfileReference()));
        }).toList();
        ArrayList<String> mergedDescriptions = new ArrayList<String>(this.description);
        mergedDescriptions.addAll(other.description);
        return new OperationDefinitionDTO(this.getId(), this.getName(), this.getStatus(), this.getKind(), mergedDescriptions, this.getCode(), mergedResources.stream().toList(), this.isSystem() || other.isSystem(), this.isType() || other.isType(), this.isInstance() || other.isInstance(), deduplicatedParams);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public String getKind() {
        return this.kind;
    }

    public String getDescription() {
        if (this.description.isEmpty()) {
            return "";
        }
        if (this.description.size() == 1) {
            return this.description.get(0);
        }
        return String.format("This automatic adding Operation was merged, because two ComplexType unionType members had fieldName with same name, but different type. Original descriptions: %n%s", String.join((CharSequence)"\n", this.description));
    }

    private void setDescription(String description) {
        this.description = List.of(description);
    }

    public String getCode() {
        return this.code;
    }

    public List<String> getResource() {
        return this.resource;
    }

    public boolean isSystem() {
        return this.system;
    }

    public boolean isType() {
        return this.type;
    }

    public boolean isInstance() {
        return this.instance;
    }

    public List<ParameterDTO> getParameter() {
        return this.parameter;
    }

    @JsonIgnore
    public ParameterDTO getParameter(String parameterName) {
        return this.getParameter().stream().filter(paramater -> paramater.getName().equals(parameterName)).findAny().orElseThrow(() -> new InvalidOperationDefinition("Parameter '%s' not found.".formatted(parameterName)));
    }

    public String toString() {
        return "OperationDefinitionDTO{id='" + this.id + "', name='" + this.name + "', status='" + this.status + "', kind='" + this.kind + "', description='" + this.description + "', code='" + this.code + "', resource=" + this.resource + ", system=" + this.system + ", type=" + this.type + ", instance=" + this.instance + ", parameter=" + this.parameter + "}";
    }

    public static class ParameterDTO {
        private String name;
        private String use;
        private Integer min;
        private String max;
        private String type;
        private List<ReferencedFrom> referencedFrom;
        private List<StructureDefinitionId> targetProfileReference;

        private ParameterDTO() {
        }

        private ParameterDTO(String name, String use, Integer min, String max, String type, List<ReferencedFrom> referencedFrom, List<StructureDefinitionId> targetProfileReference) {
            this.name = name;
            this.use = use;
            this.min = min;
            this.max = max;
            this.type = type;
            this.referencedFrom = referencedFrom;
            this.targetProfileReference = targetProfileReference;
        }

        public ParameterDTO(String name, String use, Integer min, String max, String type, ReferencedFrom referencedFrom, List<StructureDefinitionId> targetProfileReference) {
            this.name = name;
            this.use = use;
            this.min = min;
            this.max = max;
            this.type = type;
            this.referencedFrom = new ArrayList<ReferencedFrom>(List.of(referencedFrom));
            this.targetProfileReference = targetProfileReference;
        }

        public ParameterDTO merge(ParameterDTO other) {
            if (!Objects.equals(this.getName(), other.getName())) {
                throw CannotMergeOperationDefinition.becauseSomeParameterHasSomeFieldWhichIsNotSame(this.getName(), "name", this.getName(), other.getName());
            }
            if (!Objects.equals(this.getUse(), other.getUse())) {
                throw CannotMergeOperationDefinition.becauseSomeParameterHasSomeFieldWhichIsNotSame(this.getName(), "use", this.getUse(), other.getUse());
            }
            if (!Objects.equals(this.getMin(), other.getMin())) {
                throw CannotMergeOperationDefinition.becauseSomeParameterHasSomeFieldWhichIsNotSame(this.getName(), "min", this.getMin(), other.getMin());
            }
            if (!Objects.equals(this.getMax(), other.getMax())) {
                throw CannotMergeOperationDefinition.becauseSomeParameterHasSomeFieldWhichIsNotSame(this.getName(), "max", this.getMax(), other.getMax());
            }
            if (!Objects.equals(this.getType(), other.getType())) {
                throw CannotMergeOperationDefinition.becauseSomeParameterHasSomeFieldWhichIsNotSame(this.getName(), "type", this.getType(), other.getType());
            }
            ArrayList<ReferencedFrom> mergedReferencedFrom = new ArrayList<ReferencedFrom>(this.getReferencedFrom());
            mergedReferencedFrom.addAll(other.getReferencedFrom());
            ArrayList<StructureDefinitionId> mergedTargetProfileReferences = new ArrayList<StructureDefinitionId>(this.getTargetProfileReference());
            mergedTargetProfileReferences.addAll(other.getTargetProfileReference());
            return new ParameterDTO(this.getName(), this.getUse(), this.getMin(), this.getMax(), this.getType(), mergedReferencedFrom.stream().collect(Collectors.groupingBy(ReferencedFrom::getSource)).values().stream().map(group -> (ReferencedFrom)group.get(0)).toList(), mergedTargetProfileReferences.stream().collect(Collectors.groupingBy(UniqueIdentifier::getId)).values().stream().map(group -> (StructureDefinitionId)group.get(0)).toList());
        }

        public String getName() {
            return this.name;
        }

        public String getUse() {
            return this.use;
        }

        public Integer getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        public String getType() {
            return this.type;
        }

        public List<ReferencedFrom> getReferencedFrom() {
            return this.referencedFrom;
        }

        @JsonIgnore
        public ReferencedFrom getSingleReferencedFrom() {
            if (this.referencedFrom.size() != 1) {
                throw new InvalidOperationDefinition(String.format("Every parameter should always have exactly one referencedFrom value.%n%s", String.format("Operation name: '%s'", this.name)));
            }
            return this.referencedFrom.get(0);
        }

        public List<StructureDefinitionId> getTargetProfileReference() {
            return this.targetProfileReference;
        }

        @JsonIgnore
        public boolean isList() {
            try {
                int number = Integer.parseInt(this.max);
                return number > 1;
            }
            catch (RuntimeException runtimeException) {
                return this.max.equals("*");
            }
        }

        public String toString() {
            return "Parameter{name='" + this.name + "', use='" + this.use + "', min=" + this.min + ", max='" + this.max + "', type=" + this.type + "}";
        }

        public static class ReferencedFrom {
            private String source;

            private ReferencedFrom() {
            }

            public ReferencedFrom(String source) {
                this.source = source;
            }

            public String getSource() {
                return this.source;
            }
        }
    }
}

