/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.operationdefinition.model.resourceStructureTypeOperationsMapper;

import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.graphsystem.operationdefinition.model.resourceStructureTypeOperationsMapper.OperationDefinitionParameters;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;

public class ResourceOperationsMapperResult {
    private final List<OperationDefinitionDTO> operations;
    private final List<OperationDefinitionParameters> newParameters;

    public ResourceOperationsMapperResult(List<OperationDefinitionDTO> operations, List<OperationDefinitionParameters> newParameters) {
        this.operations = operations;
        this.newParameters = newParameters;
    }

    public ResourceOperationsMapperResult(List<OperationDefinitionDTO> operations) {
        this(operations, List.of());
    }

    public ResourceOperationsMapperResult(OperationDefinitionDTO operation) {
        this(List.of(operation));
    }

    public ResourceOperationsMapperResult(OperationDefinitionParameters newParameter) {
        this(List.of(), List.of(newParameter));
    }

    public ResourceOperationsMapperResult() {
        this(List.of(), List.of());
    }

    public ResourceOperationsMapperResult merge(ResourceOperationsMapperResult other) {
        ArrayList<OperationDefinitionDTO> mergedOperations = new ArrayList<OperationDefinitionDTO>(this.operations);
        mergedOperations.addAll(other.operations);
        ArrayList<OperationDefinitionParameters> mergedParameters = new ArrayList<OperationDefinitionParameters>(this.newParameters);
        mergedParameters.addAll(other.newParameters);
        return new ResourceOperationsMapperResult(mergedOperations, mergedParameters);
    }

    public List<OperationDefinitionDTO> getOperations() {
        return this.operations;
    }

    public List<OperationDefinitionParameters> getNewParameters() {
        return this.newParameters;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.operations.isEmpty() && this.newParameters.isEmpty();
    }
}

