/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.aggregategraphstatemodifier;

import ai.stapi.graph.Graph;
import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.GraphDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.UuidIdentityDescription;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.GenericOGMBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.SpecificObjectGraphMappingBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.ObjectFieldDefinitionBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.ObjectGraphMappingBuilder;
import ai.stapi.graphoperations.objectGraphMapper.model.GenericObjectGraphMapper;
import ai.stapi.graphoperations.objectGraphMapper.model.GraphMappingResult;
import ai.stapi.graphoperations.objectGraphMapper.model.MissingFieldResolvingStrategy;
import ai.stapi.graphoperations.ogmProviders.specific.dynamicObjectGraphMappingProvider.DynamicOgmProvider;
import ai.stapi.graphsystem.aggregatedefinition.model.CommandHandlerDefinitionDTO;
import ai.stapi.graphsystem.aggregategraphstatemodifier.AggregateGraphStateModificator;
import ai.stapi.graphsystem.aggregategraphstatemodifier.exceptions.CannotAddToAggregateState;
import ai.stapi.graphsystem.messaging.command.DynamicCommand;
import ai.stapi.graphsystem.operationdefinition.model.FieldDefinitionWithSource;
import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchema.ResourceStructureType;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class AddAggregateGraphStateModificator
implements AggregateGraphStateModificator {
    private final StructureSchemaFinder structureSchemaFinder;
    private final DynamicOgmProvider dynamicOgmProvider;
    private final GenericObjectGraphMapper objectGraphMapper;

    public AddAggregateGraphStateModificator(StructureSchemaFinder structureSchemaFinder, DynamicOgmProvider dynamicOgmProvider, GenericObjectGraphMapper objectGraphMapper) {
        this.structureSchemaFinder = structureSchemaFinder;
        this.dynamicOgmProvider = dynamicOgmProvider;
        this.objectGraphMapper = objectGraphMapper;
    }

    @Override
    public GraphMappingResult modify(String aggregateType, Graph currentAggregateState, DynamicCommand command, CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationStructureType, MissingFieldResolvingStrategy missingFieldResolvingStrategy) {
        Object aggregateId;
        String inputValueParameterName = modificationDefinition.getInputValueParameterName();
        if (inputValueParameterName == null) {
            throw CannotAddToAggregateState.becauseModificationDefinitionDoesNotHaveInputValueParameterNameSpecified(modificationDefinition, operationStructureType);
        }
        Object inputValue = command.getData().get(inputValueParameterName);
        if (inputValue == null) {
            return new GraphMappingResult(new Graph(), List.of());
        }
        ResourceStructureType resourceStructureType = (ResourceStructureType)this.structureSchemaFinder.getStructureType(aggregateType);
        String modificationPath = modificationDefinition.getModificationPath();
        String[] splitPath = modificationPath.split("\\.");
        FindClosestListNodePathsOutput closestListNodePaths = this.findClosestListNodePaths((ComplexStructureType)resourceStructureType, new String[]{aggregateType}, Arrays.copyOfRange(splitPath, 1, splitPath.length), operationStructureType, modificationDefinition);
        if (closestListNodePaths instanceof ErrorFindClosestListNodePathsOutput) {
            ErrorFindClosestListNodePathsOutput error = (ErrorFindClosestListNodePathsOutput)closestListNodePaths;
            throw error.getError();
        }
        HappyFindClosestListNodePathsOutput successOutput = (HappyFindClosestListNodePathsOutput)closestListNodePaths;
        String[] closestListPath = successOutput.getPaths().toList().get(0);
        InMemoryGraphRepository aggregateRepo = currentAggregateState.traversable();
        TraversableNode traversingStartNode = closestListPath.length <= 1 ? (aggregateRepo.nodeExists(aggregateId = command.getTargetIdentifier(), aggregateType) ? aggregateRepo.loadNode(aggregateId, aggregateType) : new TraversableNode(aggregateId, aggregateType)) : this.getTraversingStart(command, modificationDefinition, operationStructureType, closestListPath, aggregateRepo);
        TraversableNode modifiedNode = this.traverseToModifiedNode(traversingStartNode, Arrays.copyOfRange(splitPath, closestListPath.length, splitPath.length), Arrays.stream(closestListPath).toList(), operationStructureType, modificationDefinition);
        FieldDefinition inputValueSchema = operationStructureType.getField(inputValueParameterName);
        ObjectGraphMappingBuilder objectOgm = new ObjectGraphMappingBuilder().setGraphDescription(new GraphDescriptionBuilder().addNodeDescription(modifiedNode.getType()));
        objectOgm.addField("id").addLeafAsObjectFieldMapping().setGraphDescription((GraphDescription)new UuidIdentityDescription());
        ObjectFieldDefinitionBuilder dataField = objectOgm.addField("data");
        String fieldName = splitPath[splitPath.length - 1];
        GraphDescriptionBuilder edge = new GraphDescriptionBuilder().addOutgoingEdge(fieldName);
        if (inputValueSchema.isUnionType()) {
            if (inputValueSchema.isList()) {
                dataField.addListAsObjectFieldMapping().addInterfaceChildDefinition().setGraphDescription(edge);
            } else {
                dataField.setRelation(edge).addInterfaceAsObjectFieldMapping();
            }
        } else {
            String type = ((FieldType)inputValueSchema.getTypes().get(0)).getType();
            AbstractStructureType inputValueType = this.structureSchemaFinder.getStructureType(type);
            if (inputValueType instanceof ComplexStructureType) {
                ObjectGraphMapping inputOgm = this.dynamicOgmProvider.provideGraphMapping(type);
                SpecificObjectGraphMappingBuilder inputOgmBuilder = new GenericOGMBuilder().copyGraphMappingAsBuilder(inputOgm);
                if (inputValueSchema.isList()) {
                    dataField.addListAsObjectFieldMapping().setGraphDescription(edge).setChildDefinition(inputOgmBuilder);
                } else {
                    dataField.setRelation(edge).setOgmBuilder(inputOgmBuilder);
                }
            } else {
                ObjectGraphMapping primitiveOgm = this.dynamicOgmProvider.provideOgmForPrimitive(type, new FieldDefinition(fieldName, inputValueSchema.getMin(), inputValueSchema.getMax(), inputValueSchema.getDescription(), inputValueSchema.getTypes(), inputValueSchema.getParentDefinitionType()));
                SpecificObjectGraphMappingBuilder primitiveOgmBuilder = new GenericOGMBuilder().copyGraphMappingAsBuilder(primitiveOgm);
                dataField.setOgmBuilder(primitiveOgmBuilder);
            }
        }
        HashMap<String, Object> fakedObject = new HashMap<String, Object>(Map.of("id", modifiedNode.getId().getId(), "data", inputValue));
        return this.objectGraphMapper.mapToGraph(objectOgm.build(), fakedObject, missingFieldResolvingStrategy);
    }

    @Override
    public boolean supports(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition) {
        return modificationDefinition.getKind().equals("add");
    }

    private FindClosestListNodePathsOutput findClosestListNodePaths(ComplexStructureType currentStructure, String[] lastPathToList, String[] pathToTraverse, ComplexStructureType operationDefinition, CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition) {
        String[] currentLastPathToList = lastPathToList;
        if (pathToTraverse.length < 2) {
            ArrayList<String[]> result = new ArrayList<String[]>();
            result.add(lastPathToList);
            return new HappyFindClosestListNodePathsOutput(result.stream());
        }
        String fieldName = pathToTraverse[0];
        String[] restOfPath = Arrays.copyOfRange(pathToTraverse, 1, pathToTraverse.length);
        FieldDefinition fieldDefinition = (FieldDefinition)currentStructure.getAllFields().get(fieldName);
        if (fieldDefinition == null) {
            return new ErrorFindClosestListNodePathsOutput(CannotAddToAggregateState.becauseModificationPathContainsFieldNameNotPresentInSchema(modificationDefinition, operationDefinition));
        }
        if (fieldDefinition.isList()) {
            String[] wholePath = modificationDefinition.getModificationPath().split("\\.");
            currentLastPathToList = Arrays.copyOfRange(wholePath, 0, wholePath.length - restOfPath.length);
        }
        String[] finalCurrentLastPathToList = currentLastPathToList;
        List<FindClosestListNodePathsOutput> typeResults = fieldDefinition.getTypes().stream().map(fieldType -> {
            if (fieldType.isPrimitiveType()) {
                return new ErrorFindClosestListNodePathsOutput(CannotAddToAggregateState.becauseModificationPathContainsFieldNameWhichIsPrimitiveButItShouldNot(modificationDefinition, operationDefinition));
            }
            String type = fieldType.getType();
            ComplexStructureType structureType = (ComplexStructureType)this.structureSchemaFinder.getStructureType(type);
            return this.findClosestListNodePaths(structureType, finalCurrentLastPathToList, restOfPath, operationDefinition, modificationDefinition);
        }).toList();
        if (typeResults.stream().allMatch(ErrorFindClosestListNodePathsOutput.class::isInstance)) {
            return new ErrorFindClosestListNodePathsOutput(new CannotAddToAggregateState(typeResults.stream().map(ErrorFindClosestListNodePathsOutput.class::cast).map(ErrorFindClosestListNodePathsOutput::getError).toList()));
        }
        return new HappyFindClosestListNodePathsOutput(typeResults.stream().filter(HappyFindClosestListNodePathsOutput.class::isInstance).map(HappyFindClosestListNodePathsOutput.class::cast).flatMap(HappyFindClosestListNodePathsOutput::getPaths));
    }

    private TraversableNode traverseToModifiedNode(TraversableNode currentNode, String[] pathToTraverse, List<String> alreadyTraversedPath, ComplexStructureType operationDefinition, CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition) {
        if (pathToTraverse.length < 2) {
            return currentNode;
        }
        String fieldName = pathToTraverse[0];
        List edges = currentNode.getEdges(fieldName);
        ArrayList<String> newAlreadyTraversedPath = new ArrayList<String>(alreadyTraversedPath);
        newAlreadyTraversedPath.add(fieldName);
        if (edges.size() > 1) {
            throw CannotAddToAggregateState.becauseThereAreEdgesOnPathEvenThoughtThereShouldBeMaxOne(modificationDefinition, operationDefinition, String.join((CharSequence)".", newAlreadyTraversedPath));
        }
        if (edges.isEmpty()) {
            throw CannotAddToAggregateState.becauseThereAreIsNodeEdgeOnPathEvenThoughtThereShouldBeOne(modificationDefinition, operationDefinition, String.join((CharSequence)".", newAlreadyTraversedPath));
        }
        return this.traverseToModifiedNode(((TraversableEdge)edges.get(0)).getNodeTo(), Arrays.copyOfRange(pathToTraverse, 1, pathToTraverse.length), newAlreadyTraversedPath, operationDefinition, modificationDefinition);
    }

    private TraversableNode getTraversingStart(DynamicCommand command, CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationStructureType, String[] closestListPath, InMemoryGraphRepository aggregateRepo) {
        String sourcePathOfId = String.format("%s.id", String.join((CharSequence)".", closestListPath));
        List<FieldDefinitionWithSource> idParametersWithSameSourcePath = operationStructureType.getAllFields().values().stream().map(FieldDefinitionWithSource.class::cast).filter(fieldDefinition -> fieldDefinition.getSource().equals(sourcePathOfId)).toList();
        if (idParametersWithSameSourcePath.isEmpty()) {
            throw CannotAddToAggregateState.becauseThereAreIndistinguishableNodes(modificationDefinition, operationStructureType, sourcePathOfId);
        }
        if (idParametersWithSameSourcePath.size() > 1) {
            throw CannotAddToAggregateState.becauseThereAreMoreWaysToDistinguisNodes(modificationDefinition, operationStructureType, sourcePathOfId);
        }
        FieldDefinitionWithSource idParameter = idParametersWithSameSourcePath.get(0);
        Object idValue = command.getData().get(idParameter.getName());
        if (!(idValue instanceof String)) {
            throw new CannotAddToAggregateState(List.of());
        }
        String stringIdValue = (String)idValue;
        UniqueIdentifier id = new UniqueIdentifier(stringIdValue);
        if (aggregateRepo.nodeExists(id)) {
            return aggregateRepo.loadNode(id);
        }
        throw CannotAddToAggregateState.becauseThereIsNoNodeWithIdSpecifiedAtSourcePath(modificationDefinition, operationStructureType, String.join((CharSequence)".", closestListPath), id);
    }

    private static interface FindClosestListNodePathsOutput {
    }

    private static class ErrorFindClosestListNodePathsOutput
    implements FindClosestListNodePathsOutput {
        private final CannotAddToAggregateState error;

        public ErrorFindClosestListNodePathsOutput(CannotAddToAggregateState error) {
            this.error = error;
        }

        public CannotAddToAggregateState getError() {
            return this.error;
        }
    }

    private static class HappyFindClosestListNodePathsOutput
    implements FindClosestListNodePathsOutput {
        private final Stream<String[]> paths;

        public HappyFindClosestListNodePathsOutput(Stream<String[]> paths) {
            this.paths = paths;
        }

        public Stream<String[]> getPaths() {
            return this.paths;
        }
    }

    private record ClosestJoinInfo(String nodeId, String nodeType, String fieldName) {
    }
}

