/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.dynamiccommandprocessor;

import ai.stapi.graph.Graph;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphMapper.model.GenericObjectGraphMapper;
import ai.stapi.graphoperations.objectGraphMapper.model.GraphMappingResult;
import ai.stapi.graphoperations.objectGraphMapper.model.MissingFieldResolvingStrategy;
import ai.stapi.graphsystem.commandEventGraphMappingProvider.GenericCommandEventGraphMappingProvider;
import ai.stapi.graphsystem.dynamiccommandprocessor.SpecificDynamicCommandProcessor;
import ai.stapi.graphsystem.genericGraphEventFactory.GenericGraphEventFactory;
import ai.stapi.graphsystem.messaging.command.AbstractCommand;
import ai.stapi.graphsystem.messaging.event.AggregateGraphUpdatedEvent;
import ai.stapi.identity.UniqueIdentifier;
import java.util.List;
import java.util.Map;

public class BasicDynamicCommandProcessor
implements SpecificDynamicCommandProcessor {
    protected final GenericObjectGraphMapper objectGraphMapper;
    protected final GenericGraphEventFactory genericEventFactory;
    protected final GenericCommandEventGraphMappingProvider commandEventGraphMappingProvider;

    public BasicDynamicCommandProcessor(GenericObjectGraphMapper objectGraphMapper, GenericGraphEventFactory genericEventFactory, GenericCommandEventGraphMappingProvider commandEventGraphMappingProvider) {
        this.objectGraphMapper = objectGraphMapper;
        this.genericEventFactory = genericEventFactory;
        this.commandEventGraphMappingProvider = commandEventGraphMappingProvider;
    }

    @Override
    public List<? extends AggregateGraphUpdatedEvent<? extends UniqueIdentifier>> processCommand(AbstractCommand<? extends UniqueIdentifier> command, Graph currentAggregateState, MissingFieldResolvingStrategy missingFieldResolvingStrategy) {
        Map<Class<? extends AggregateGraphUpdatedEvent<? extends UniqueIdentifier>>, ObjectGraphMapping> eventMappings = this.commandEventGraphMappingProvider.provideGraphMappings(command);
        return eventMappings.entrySet().stream().map(entry -> {
            GraphMappingResult result = this.objectGraphMapper.mapToGraph((ObjectGraphMapping)entry.getValue(), (Object)command, missingFieldResolvingStrategy);
            return this.genericEventFactory.createEvent((Class)entry.getKey(), (UniqueIdentifier)command.getTargetIdentifier(), result.getGraph(), result.getElementForRemoval());
        }).toList();
    }

    @Override
    public boolean supports(AbstractCommand<? extends UniqueIdentifier> command) {
        return this.commandEventGraphMappingProvider.containsFor(command);
    }
}

