/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.fixtures.fixtureCommandsGenerator;

import ai.stapi.graphsystem.fixtures.fixtureCommandsGenerator.FileFixtureCommandsGenerator;
import ai.stapi.graphsystem.messaging.command.Command;
import ai.stapi.graphsystem.messaging.command.DynamicCommand;
import ai.stapi.graphsystem.structuredefinition.command.importStructureDefinitionFromSource.ImportStructureDefinition;
import ai.stapi.schema.adHocLoaders.FileLoader;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractModelFileFixtureGenerator
extends FileFixtureCommandsGenerator {
    protected AbstractModelFileFixtureGenerator(ObjectMapper objectMapper, FileLoader fileLoader) {
        super(objectMapper, fileLoader);
    }

    private static boolean isKind(Command command, String filterType) {
        if (command instanceof DynamicCommand) {
            DynamicCommand dynamicCommand = (DynamicCommand)command;
            return dynamicCommand.getData().get("kind").equals(filterType);
        }
        if (command instanceof ImportStructureDefinition) {
            ImportStructureDefinition importStructureDefinition = (ImportStructureDefinition)command;
            return importStructureDefinition.getStructureDefinitionSource().getKind().equals(filterType);
        }
        return false;
    }

    @Override
    protected List<Command> sortCommands(List<Command> list) {
        ArrayList<Command> sortedList = new ArrayList<Command>();
        List<ImportStructureDefinition> importStructuresCommand = list.stream().filter(ImportStructureDefinition.class::isInstance).map(ImportStructureDefinition.class::cast).toList();
        sortedList.addAll(importStructuresCommand.stream().filter(command -> AbstractModelFileFixtureGenerator.isKind(command, "primitive-type")).toList());
        sortedList.addAll(importStructuresCommand.stream().filter(command -> AbstractModelFileFixtureGenerator.isKind(command, "complex-type")).toList());
        sortedList.addAll(importStructuresCommand.stream().filter(command -> AbstractModelFileFixtureGenerator.isKind(command, "resource")).toList());
        List<Command> rest = list.stream().filter(command -> !(command instanceof ImportStructureDefinition)).toList();
        sortedList.addAll(rest);
        return sortedList;
    }
}

