/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.structuredefinition.loader;

import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.EdgeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.OutgoingEdgeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.UuidIdentityDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.AttributeQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.GraphElementQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.NodeQueryGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.OutgoingEdgeQueryDescription;
import ai.stapi.graphoperations.graphLoader.GraphLoader;
import ai.stapi.graphoperations.graphLoader.GraphLoaderReturnType;
import ai.stapi.graphoperations.graphLoader.search.SearchQueryParameters;
import ai.stapi.graphoperations.graphLoader.search.paginationOption.OffsetPaginationOption;
import ai.stapi.graphoperations.graphLoader.search.paginationOption.PaginationOption;
import ai.stapi.graphsystem.structuredefinition.loader.SystemAdHocStructureDefinitionLoader;
import ai.stapi.schema.scopeProvider.ScopeCacher;
import ai.stapi.schema.scopeProvider.ScopeOptions;
import ai.stapi.schema.scopeProvider.ScopeProvider;
import ai.stapi.schema.structuredefinition.StructureDefinitionData;
import ai.stapi.schema.structuredefinition.loader.StructureDefinitionLoader;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;

public class DatabaseStructureDefinitionLoader
implements StructureDefinitionLoader {
    private final GraphLoader graphLoader;
    private final SystemAdHocStructureDefinitionLoader systemAdHocStructureDefinitionLoader;
    private final ScopeCacher scopeCacher;
    private final ScopeProvider scopeProvider;

    public DatabaseStructureDefinitionLoader(@Lazy GraphLoader graphLoader, SystemAdHocStructureDefinitionLoader systemAdHocStructureDefinitionLoader, ScopeCacher scopeCacher, ScopeProvider scopeProvider) {
        this.graphLoader = graphLoader;
        this.systemAdHocStructureDefinitionLoader = systemAdHocStructureDefinitionLoader;
        this.scopeCacher = scopeCacher;
        this.scopeProvider = scopeProvider;
    }

    public List<StructureDefinitionData> load() {
        ScopeOptions systemScope = new ScopeOptions("system", "domain");
        if (this.scopeProvider.provide().equals((Object)systemScope)) {
            return this.systemAdHocStructureDefinitionLoader.load();
        }
        if (!this.scopeCacher.hasCached(DatabaseStructureDefinitionLoader.class)) {
            ScopeOptions originalScope = this.scopeProvider.provide();
            this.scopeProvider.set(systemScope);
            List<StructureDefinitionData> data = this.loadData();
            this.scopeProvider.set(originalScope);
            this.scopeCacher.cache(DatabaseStructureDefinitionLoader.class, data);
            return data;
        }
        return (List)this.scopeCacher.getCachedOrCompute(DatabaseStructureDefinitionLoader.class, scope -> this.loadData());
    }

    private List<StructureDefinitionData> loadData() {
        return this.graphLoader.find((GraphElementQueryDescription)this.getStructureDefinitionGraphDescription(), StructureDefinitionData.class, new GraphLoaderReturnType[0]).getData();
    }

    @NotNull
    private NodeQueryGraphDescription getStructureDefinitionGraphDescription() {
        return new NodeQueryGraphDescription(new NodeDescriptionParameters("StructureDefinition"), SearchQueryParameters.builder().setPaginationOption((PaginationOption)new OffsetPaginationOption(Integer.valueOf(0), Integer.valueOf(300))).build(), new GraphDescription[]{new UuidIdentityDescription(), new AttributeQueryDescription("url"), new AttributeQueryDescription("status"), new AttributeQueryDescription("description"), new AttributeQueryDescription("kind"), new AttributeQueryDescription("abstract"), new AttributeQueryDescription("type"), new OutgoingEdgeDescription(new EdgeDescriptionParameters("baseDefinitionReference"), new GraphDescription[]{new NodeDescription(new NodeDescriptionParameters("StructureDefinition"), new GraphDescription[]{new UuidIdentityDescription()})}), new OutgoingEdgeDescription(new EdgeDescriptionParameters("differential"), new GraphDescription[]{new NodeDescription(new NodeDescriptionParameters("StructureDefinitionDifferential"), new GraphDescription[]{new OutgoingEdgeQueryDescription(new EdgeDescriptionParameters("element"), SearchQueryParameters.builder().setPaginationOption((PaginationOption)new OffsetPaginationOption(Integer.valueOf(0), Integer.valueOf(300))).build(), new GraphDescription[]{new NodeDescription(new NodeDescriptionParameters("ElementDefinition"), new GraphDescription[]{new AttributeQueryDescription("path"), new AttributeQueryDescription("min"), new AttributeQueryDescription("max"), new AttributeQueryDescription("short"), new AttributeQueryDescription("definition"), new AttributeQueryDescription("comment"), new AttributeQueryDescription("contentReference"), new OutgoingEdgeQueryDescription(new EdgeDescriptionParameters("type"), SearchQueryParameters.builder().setPaginationOption((PaginationOption)new OffsetPaginationOption(Integer.valueOf(0), Integer.valueOf(300))).build(), new GraphDescription[]{new NodeDescription(new NodeDescriptionParameters("ElementDefinitionType"), new GraphDescription[]{new AttributeQueryDescription("code"), new AttributeQueryDescription("targetProfile")})})})})})})});
    }
}

