/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.aggregatedefinition.infrastructure;

import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.EdgeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.OutgoingEdgeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.UuidIdentityDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.AttributeQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.GraphElementQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.NodeQueryGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.OutgoingEdgeQueryDescription;
import ai.stapi.graphoperations.graphLoader.GraphLoader;
import ai.stapi.graphoperations.graphLoader.GraphLoaderReturnType;
import ai.stapi.graphoperations.graphLoader.search.SearchQueryParameters;
import ai.stapi.graphoperations.graphLoader.search.paginationOption.OffsetPaginationOption;
import ai.stapi.graphoperations.graphLoader.search.paginationOption.PaginationOption;
import ai.stapi.graphsystem.aggregatedefinition.model.AggregateDefinitionDTO;
import ai.stapi.graphsystem.aggregatedefinition.model.AggregateDefinitionProvider;
import ai.stapi.graphsystem.operationdefinition.exceptions.CannotProvideOperationDefinition;
import ai.stapi.graphsystem.operationdefinition.infrastructure.DatabaseOperationDefinitionProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DatabaseAggregateDefinitionProvider
implements AggregateDefinitionProvider {
    private final GraphLoader graphLoader;
    private final DatabaseOperationDefinitionProvider databaseOperationDefinitionProvider;
    private List<AggregateDefinitionDTO> cachedAggregates;

    public DatabaseAggregateDefinitionProvider(GraphLoader graphLoader, DatabaseOperationDefinitionProvider databaseOperationDefinitionProvider) {
        this.graphLoader = graphLoader;
        this.databaseOperationDefinitionProvider = databaseOperationDefinitionProvider;
        this.cachedAggregates = new ArrayList<AggregateDefinitionDTO>();
    }

    @Override
    public List<AggregateDefinitionDTO> provideAll() {
        this.cacheOperations();
        return this.cachedAggregates;
    }

    @Override
    public AggregateDefinitionDTO provide(String operationId) throws CannotProvideOperationDefinition {
        this.cacheOperations();
        return this.cachedAggregates.stream().filter(operation -> operation.getId().equals(operationId)).findFirst().orElseThrow(() -> new CannotProvideOperationDefinition(operationId));
    }

    private void cacheOperations() {
        if (this.cachedAggregates.isEmpty()) {
            this.cachedAggregates = this.graphLoader.find((GraphElementQueryDescription)this.getAggregateGraphDescription(), AggregateDefinitionDTO.class, new GraphLoaderReturnType[0]).getData();
        }
    }

    private NodeQueryGraphDescription getAggregateGraphDescription() {
        return new NodeQueryGraphDescription(new NodeDescriptionParameters("AggregateDefinition"), SearchQueryParameters.builder().setPaginationOption((PaginationOption)new OffsetPaginationOption(Integer.valueOf(0), Integer.valueOf(50000))).build(), new GraphDescription[]{new UuidIdentityDescription(), new AttributeQueryDescription("name"), new AttributeQueryDescription("description"), new OutgoingEdgeQueryDescription(new EdgeDescriptionParameters("command"), SearchQueryParameters.builder().setPaginationOption((PaginationOption)new OffsetPaginationOption(Integer.valueOf(0), Integer.valueOf(300))).build(), new GraphDescription[]{this.getCommandHandlerGraphDescription()}), new OutgoingEdgeDescription(new EdgeDescriptionParameters("structure"), new GraphDescription[]{new NodeDescription(new NodeDescriptionParameters("StructureDefinition"), new GraphDescription[]{new UuidIdentityDescription()})})});
    }

    @NotNull
    private NodeDescription getCommandHandlerGraphDescription() {
        return new NodeDescription(new NodeDescriptionParameters("CommandHandlerDefinition"), new GraphDescription[]{new AttributeQueryDescription("creationalPolicy"), new OutgoingEdgeDescription(new EdgeDescriptionParameters("operation"), new GraphDescription[]{this.databaseOperationDefinitionProvider.getOperationGraphDescription()}), new OutgoingEdgeQueryDescription(new EdgeDescriptionParameters("eventFactory"), SearchQueryParameters.builder().setPaginationOption((PaginationOption)new OffsetPaginationOption(Integer.valueOf(0), Integer.valueOf(300))).build(), new GraphDescription[]{this.getEventFactoryGraphDescription()})});
    }

    @NotNull
    private NodeDescription getEventFactoryGraphDescription() {
        return new NodeDescription("CommandHandlerDefinitionEventFactory", new GraphDescription[]{new UuidIdentityDescription(), new OutgoingEdgeDescription(new EdgeDescriptionParameters("event"), new GraphDescription[]{this.getEventMessageGraphDescription()}), new OutgoingEdgeDescription(new EdgeDescriptionParameters("modification"), new GraphDescription[]{new NodeDescription("CommandHandlerDefinitionEventFactoryModification", new GraphDescription[]{new AttributeQueryDescription("kind"), new AttributeQueryDescription("modificationPath"), new AttributeQueryDescription("inputValueParameterName"), new AttributeQueryDescription("destinationIndexParameterName")})})});
    }

    @NotNull
    private NodeDescription getEventMessageGraphDescription() {
        return new NodeDescription(new NodeDescriptionParameters("EventMessageDefinition"), new GraphDescription[]{new AttributeQueryDescription("name"), new AttributeQueryDescription("description"), new OutgoingEdgeDescription(new EdgeDescriptionParameters("type"), new GraphDescription[]{new NodeDescription(new NodeDescriptionParameters("StructureDefinition")), new UuidIdentityDescription()})});
    }
}

