/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.fixtures.fixtureCommandsGenerator;

import ai.stapi.graphsystem.fixtures.fixtureCommandsGenerator.FixtureCommandsGenerator;
import ai.stapi.graphsystem.fixtures.fixtureCommandsGenerator.FixtureCommandsGeneratorResult;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;

public class GenericFixtureCommandsGenerator {
    private final List<FixtureCommandsGenerator> fixtureCommandsGenerators;

    @Autowired
    public GenericFixtureCommandsGenerator(List<FixtureCommandsGenerator> fixtureCommandsGenerators) {
        this.fixtureCommandsGenerators = fixtureCommandsGenerators;
    }

    public Stream<FixtureCommandsGeneratorResult> generate(List<String> tags, List<String> processedGenerators, Set<String> processedFileNames, float minPriority, float maxPriority) {
        List<FixtureCommandsGeneratorResult> fixtureCommandResults = this.fixtureCommandsGenerators.stream().filter(fixtureCommandsGenerator -> fixtureCommandsGenerator.getPriority() >= minPriority && fixtureCommandsGenerator.getPriority() <= maxPriority).sorted(Comparator.comparingDouble(FixtureCommandsGenerator::getPriority).reversed()).filter(generator -> generator.getFixtureTags().stream().anyMatch(tags::contains) && !processedGenerators.contains(generator.getGeneratorName())).map(fixtureCommandsGenerator -> fixtureCommandsGenerator.generate(processedFileNames)).toList();
        return fixtureCommandResults.stream();
    }
}

