/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.aggregatedefinition.model;

import ai.stapi.graphsystem.aggregatedefinition.model.AggregateDefinitionDTO;
import ai.stapi.graphsystem.aggregatedefinition.model.exceptions.CannotProvideAggregateDefinition;
import java.util.List;

public interface AggregateDefinitionProvider {
    public List<AggregateDefinitionDTO> provideAll();

    public AggregateDefinitionDTO provide(String var1) throws CannotProvideAggregateDefinition;

    default public AggregateDefinitionDTO getAggregateForOperation(String operationDefinitionId) throws CannotProvideAggregateDefinition {
        List<AggregateDefinitionDTO> foundAggregates = this.provideAll().stream().filter(aggregate -> aggregate.containsOperation(operationDefinitionId)).toList();
        if (foundAggregates.isEmpty()) {
            throw CannotProvideAggregateDefinition.becauseThereIsNoCommandHandlerForOperation(operationDefinitionId);
        }
        return foundAggregates.get(0);
    }

    default public boolean containsAggregateForOperation(String operationDefinitionId) {
        return this.provideAll().stream().anyMatch(aggregate -> aggregate.containsOperation(operationDefinitionId));
    }
}

