/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.fixtures.fixtureCommandsGenerator;

import ai.stapi.graphsystem.fixtures.fixtureCommandsGenerator.CommandDefinition;
import ai.stapi.graphsystem.messaging.command.Command;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

public class CommandDefinitionClassNameDeserializer
extends StdDeserializer<CommandDefinition> {
    public CommandDefinitionClassNameDeserializer() {
        this(null);
    }

    protected CommandDefinitionClassNameDeserializer(Class<?> vc) {
        super(vc);
    }

    public CommandDefinition deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String commandClassName = node.get("name").asText();
        try {
            Class<?> commandClazz = Class.forName(commandClassName);
            String serializedCommand = node.get("command").toString();
            Command command = (Command)new ObjectMapper().readValue(serializedCommand, commandClazz);
            return new CommandDefinition(command);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

