/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.operationdefinition.infrastructure;

import ai.stapi.graphsystem.operationdefinition.exceptions.CannotProvideOperationDefinition;
import ai.stapi.graphsystem.operationdefinition.exceptions.CannotProvideOperationDefinitions;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionProvider;
import ai.stapi.schema.adHocLoaders.GenericAdHocModelDefinitionsLoader;
import ai.stapi.schema.scopeProvider.ScopeCacher;
import ai.stapi.schema.scopeProvider.ScopeOptions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AdHocOperationDefinitionProvider
implements OperationDefinitionProvider {
    private final GenericAdHocModelDefinitionsLoader genericAdHocModelDefinitionsLoader;
    private final ScopeCacher scopeCacher;

    public AdHocOperationDefinitionProvider(GenericAdHocModelDefinitionsLoader genericAdHocModelDefinitionsLoader, ScopeCacher scopeCacher) {
        this.genericAdHocModelDefinitionsLoader = genericAdHocModelDefinitionsLoader;
        this.scopeCacher = scopeCacher;
    }

    @Override
    public List<OperationDefinitionDTO> provideAll() {
        return this.getOperationDefinitions();
    }

    @Override
    public OperationDefinitionDTO provide(String operationId) throws CannotProvideOperationDefinition {
        return this.getOperationDefinitions().stream().filter(operation -> operation.getId().equals(operationId)).findFirst().orElseThrow(() -> new CannotProvideOperationDefinition(operationId));
    }

    @Override
    public boolean contains(String operationId) {
        return this.getOperationDefinitions().stream().anyMatch(operation -> operation.getId().equals(operationId));
    }

    private List<OperationDefinitionDTO> getOperationDefinitions() {
        return (List)this.scopeCacher.getCachedOrCompute(AdHocOperationDefinitionProvider.class, this::load);
    }

    private List<OperationDefinitionDTO> load(ScopeOptions scopeOptions) {
        List createOperation = this.genericAdHocModelDefinitionsLoader.load(scopeOptions, "CreateOperationDefinition", OperationDefinitionDTO.class).stream().toList();
        List addParameterOnOperation = this.genericAdHocModelDefinitionsLoader.load(scopeOptions, "AddParameterOnOperationDefinition", AddParameterOnOperationDefinitionDTO.class).stream().toList();
        List<AddParameterOnOperationDefinitionDTO> addParameterWithoutTarget = addParameterOnOperation.stream().filter(map -> this.isContainedInFoundOperations(createOperation, (AddParameterOnOperationDefinitionDTO)map)).toList();
        if (!addParameterWithoutTarget.isEmpty()) {
            throw new CannotProvideOperationDefinitions(String.format("Cannot provide operation definitions for scope: %s with tags: %s.%n%s%n%s", scopeOptions.getScopes(), scopeOptions.getTags(), "There were some AddParameterOnOperationDefinition JSONs which eiter did not have id specified or it was missing in found OperationDefinitions.", "Missing ids: " + addParameterWithoutTarget.stream().map(AddParameterOnOperationDefinitionDTO::getId).toList()));
        }
        Map<String, List<AddParameterOnOperationDefinitionDTO>> groupedParams = addParameterOnOperation.stream().collect(Collectors.groupingBy(AddParameterOnOperationDefinitionDTO::getId));
        return createOperation.stream().map(operation -> {
            List addedParameters = (List)groupedParams.get(operation.getId());
            if (addedParameters == null) {
                return operation;
            }
            List<OperationDefinitionDTO.ParameterDTO> newParameters = addedParameters.stream().map(AddParameterOnOperationDefinitionDTO::getParameter).flatMap(Collection::stream).toList();
            operation.addParameters(newParameters);
            return operation;
        }).toList();
    }

    private boolean isContainedInFoundOperations(List<OperationDefinitionDTO> createOperation, AddParameterOnOperationDefinitionDTO addParameterDTO) {
        return addParameterDTO.getId() == null || createOperation.stream().noneMatch(operation -> operation.getId().equals(addParameterDTO.getId()));
    }

    private static class AddParameterOnOperationDefinitionDTO {
        private String id;
        private List<OperationDefinitionDTO.ParameterDTO> parameter;

        private AddParameterOnOperationDefinitionDTO() {
        }

        public AddParameterOnOperationDefinitionDTO(String id, List<OperationDefinitionDTO.ParameterDTO> parameter) {
            this.id = id;
            this.parameter = parameter;
        }

        public String getId() {
            return this.id;
        }

        public List<OperationDefinitionDTO.ParameterDTO> getParameter() {
            return this.parameter;
        }
    }
}

