/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.aggregategraphstatemodifier;

import ai.stapi.graph.exceptions.NodeNotFound;
import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.GraphDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.UuidIdentityDescription;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.GenericOGMBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.SpecificObjectGraphMappingBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.ObjectFieldDefinitionBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.ObjectGraphMappingBuilder;
import ai.stapi.graphoperations.objectGraphMapper.model.GenericObjectGraphMapper;
import ai.stapi.graphoperations.ogmProviders.specific.dynamicObjectGraphMappingProvider.DynamicOgmProvider;
import ai.stapi.graphsystem.aggregatedefinition.model.CommandHandlerDefinitionDTO;
import ai.stapi.graphsystem.aggregategraphstatemodifier.AggregateGraphStateModificator;
import ai.stapi.graphsystem.aggregategraphstatemodifier.exceptions.CannotModifyAggregateState;
import ai.stapi.graphsystem.messaging.command.DynamicCommand;
import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAggregateGraphStateModificator
implements AggregateGraphStateModificator {
    protected final StructureSchemaFinder structureSchemaFinder;
    protected final DynamicOgmProvider dynamicOgmProvider;
    protected final GenericObjectGraphMapper objectGraphMapper;

    public AbstractAggregateGraphStateModificator(StructureSchemaFinder structureSchemaFinder, DynamicOgmProvider dynamicOgmProvider, GenericObjectGraphMapper objectGraphMapper) {
        this.structureSchemaFinder = structureSchemaFinder;
        this.dynamicOgmProvider = dynamicOgmProvider;
        this.objectGraphMapper = objectGraphMapper;
    }

    @NotNull
    protected Map<String, Object> getMappedObject(Object inputValue, TraversableNode modifiedNode, String fieldName) {
        return new HashMap<String, Object>(Map.of("id", modifiedNode.getId().getId(), fieldName, inputValue));
    }

    @NotNull
    protected ObjectGraphMapping getOgm(TraversableNode modifiedNode, FieldDefinition inputValueSchema, String fieldName) {
        ObjectGraphMappingBuilder objectOgm = new ObjectGraphMappingBuilder().setGraphDescription(new GraphDescriptionBuilder().addNodeDescription(modifiedNode.getType()));
        objectOgm.addField("id").addLeafAsObjectFieldMapping().setGraphDescription((GraphDescription)new UuidIdentityDescription());
        ObjectFieldDefinitionBuilder dataField = objectOgm.addField(fieldName);
        GraphDescriptionBuilder edge = new GraphDescriptionBuilder().addOutgoingEdge(fieldName);
        if (inputValueSchema.isUnionType()) {
            if (inputValueSchema.isList()) {
                dataField.addListAsObjectFieldMapping().addInterfaceChildDefinition().setGraphDescription(edge);
            } else {
                dataField.setRelation(edge).addInterfaceAsObjectFieldMapping();
            }
        } else {
            String type = ((FieldType)inputValueSchema.getTypes().get(0)).getType();
            AbstractStructureType inputValueType = this.structureSchemaFinder.getStructureType(type);
            if (inputValueType instanceof ComplexStructureType) {
                ObjectGraphMapping inputOgm = this.dynamicOgmProvider.provideGraphMapping(type);
                SpecificObjectGraphMappingBuilder inputOgmBuilder = new GenericOGMBuilder().copyGraphMappingAsBuilder(inputOgm);
                if (inputValueSchema.isList()) {
                    dataField.addListAsObjectFieldMapping().setGraphDescription(edge).setChildDefinition(inputOgmBuilder);
                } else {
                    dataField.setRelation(edge).setOgmBuilder(inputOgmBuilder);
                }
            } else {
                ObjectGraphMapping primitiveOgm = this.dynamicOgmProvider.provideOgmForPrimitive(type, new FieldDefinition(fieldName, inputValueSchema.getMin(), inputValueSchema.getMax(), inputValueSchema.getDescription(), inputValueSchema.getTypes(), inputValueSchema.getParentDefinitionType()));
                SpecificObjectGraphMappingBuilder primitiveOgmBuilder = new GenericOGMBuilder().copyGraphMappingAsBuilder(primitiveOgm);
                dataField.setOgmBuilder(primitiveOgmBuilder);
            }
        }
        return objectOgm.build();
    }

    protected TraversableNode getTraversingStartNode(String aggregateType, DynamicCommand command, CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationStructureType, InMemoryGraphRepository aggregateRepo) {
        String startIdParameterName = modificationDefinition.getStartIdParameterName();
        if (startIdParameterName == null) {
            Object aggregateId = command.getTargetIdentifier();
            if (aggregateRepo.nodeExists(aggregateId, aggregateType)) {
                return aggregateRepo.loadNode(aggregateId, aggregateType);
            }
            return new TraversableNode(aggregateId, aggregateType);
        }
        Object startIdValue = command.getData().get(startIdParameterName);
        if (!(startIdValue instanceof String)) {
            throw CannotModifyAggregateState.becauseThereIsNoIdInCommandAtStartIdParameterName(startIdParameterName, modificationDefinition, operationStructureType);
        }
        String stringStartId = (String)startIdValue;
        if (!stringStartId.contains("/")) {
            throw CannotModifyAggregateState.becauseStartIdIsNotOfCorrectFormat(stringStartId, startIdParameterName, modificationDefinition, operationStructureType);
        }
        String[] splitId = stringStartId.split("/");
        if (splitId.length != 2) {
            throw CannotModifyAggregateState.becauseStartIdIsNotOfCorrectFormat(stringStartId, startIdParameterName, modificationDefinition, operationStructureType);
        }
        try {
            return aggregateRepo.loadNode(new UniqueIdentifier(splitId[1]), splitId[0]);
        }
        catch (NodeNotFound nodeNotFound) {
            throw CannotModifyAggregateState.becauseThereIsNoNodeWithIdSpecifiedAtStartIdParameterName(modificationDefinition, operationStructureType, new UniqueIdentifier(stringStartId), startIdParameterName);
        }
    }

    protected TraversableNode traverseToModifiedNode(TraversableNode currentNode, String[] pathToTraverse, List<String> alreadyTraversedPath, ComplexStructureType operationDefinition, CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition) {
        if (pathToTraverse.length < 2) {
            return currentNode;
        }
        String fieldName = pathToTraverse[0];
        List edges = currentNode.getEdges(fieldName);
        ArrayList<String> newAlreadyTraversedPath = new ArrayList<String>(alreadyTraversedPath);
        newAlreadyTraversedPath.add(fieldName);
        if (edges.size() > 1) {
            throw CannotModifyAggregateState.becauseThereAreEdgesOnPathEvenThoughtThereShouldBeMaxOne(modificationDefinition, operationDefinition, String.join((CharSequence)".", newAlreadyTraversedPath));
        }
        if (edges.isEmpty()) {
            throw CannotModifyAggregateState.becauseThereAreIsNodeEdgeOnPathEvenThoughtThereShouldBeOne(modificationDefinition, operationDefinition, String.join((CharSequence)".", newAlreadyTraversedPath));
        }
        return this.traverseToModifiedNode(((TraversableEdge)edges.get(0)).getNodeTo(), Arrays.copyOfRange(pathToTraverse, 1, pathToTraverse.length), newAlreadyTraversedPath, operationDefinition, modificationDefinition);
    }
}

