/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.aggregategraphstatemodifier;

import ai.stapi.graph.AttributeContainer;
import ai.stapi.graph.Graph;
import ai.stapi.graph.graphelements.Node;
import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphMapper.model.GenericObjectGraphMapper;
import ai.stapi.graphoperations.objectGraphMapper.model.GraphMappingResult;
import ai.stapi.graphoperations.objectGraphMapper.model.MissingFieldResolvingStrategy;
import ai.stapi.graphoperations.ogmProviders.specific.dynamicObjectGraphMappingProvider.DynamicOgmProvider;
import ai.stapi.graphsystem.aggregatedefinition.model.CommandHandlerDefinitionDTO;
import ai.stapi.graphsystem.aggregategraphstatemodifier.AbstractAggregateGraphStateModificator;
import ai.stapi.graphsystem.aggregategraphstatemodifier.exceptions.CannotAddToAggregateState;
import ai.stapi.graphsystem.messaging.command.DynamicCommand;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.List;
import java.util.Map;

public class AddAggregateGraphStateModificator
extends AbstractAggregateGraphStateModificator {
    public AddAggregateGraphStateModificator(StructureSchemaFinder structureSchemaFinder, DynamicOgmProvider dynamicOgmProvider, GenericObjectGraphMapper objectGraphMapper) {
        super(structureSchemaFinder, dynamicOgmProvider, objectGraphMapper);
    }

    @Override
    public GraphMappingResult modify(String aggregateType, Graph currentAggregateState, DynamicCommand command, CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationStructureType, MissingFieldResolvingStrategy missingFieldResolvingStrategy) {
        String inputValueParameterName = modificationDefinition.getInputValueParameterName();
        if (inputValueParameterName == null) {
            throw CannotAddToAggregateState.becauseModificationDefinitionDoesNotHaveInputValueParameterNameSpecified(modificationDefinition, operationStructureType);
        }
        Object inputValue = command.getData().get(inputValueParameterName);
        if (inputValue == null) {
            return new GraphMappingResult(new Graph(new AttributeContainer[]{new Node(command.getTargetIdentifier(), aggregateType)}), List.of());
        }
        InMemoryGraphRepository aggregateRepo = currentAggregateState.traversable();
        TraversableNode traversingStartNode = this.getTraversingStartNode(aggregateType, command, modificationDefinition, operationStructureType, aggregateRepo);
        String modificationPath = modificationDefinition.getModificationPath();
        TraversableNode modifiedNode = this.traverseToModifiedNode(traversingStartNode, modificationPath.split("\\."), List.of(), operationStructureType, modificationDefinition);
        String[] splitPath = modificationPath.split("\\.");
        FieldDefinition inputValueSchema = operationStructureType.getField(inputValueParameterName);
        String fieldName = splitPath[splitPath.length - 1];
        if (inputValueSchema.getFloatMax().floatValue() < 2.0f) {
            if (!modifiedNode.getEdges(fieldName).isEmpty()) {
                throw CannotAddToAggregateState.becauseThereAlreadyIsSuchLeafComplexType(modificationDefinition, operationStructureType, modifiedNode);
            }
            if (modifiedNode.hasAttribute(fieldName)) {
                throw CannotAddToAggregateState.becauseThereAlreadyIsSuchLeafAttribute(modificationDefinition, operationStructureType, modifiedNode);
            }
        }
        ObjectGraphMapping objectOgm = this.getOgm(modifiedNode, inputValueSchema, fieldName);
        Map<String, Object> fakedObject = this.getMappedObject(inputValue, modifiedNode, fieldName);
        return this.objectGraphMapper.mapToGraph(objectOgm, fakedObject, missingFieldResolvingStrategy);
    }

    @Override
    public boolean supports(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition) {
        return modificationDefinition.getKind().equals("add");
    }
}

