/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.aggregategraphstatemodifier;

import ai.stapi.graph.Graph;
import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphMapper.model.GenericObjectGraphMapper;
import ai.stapi.graphoperations.objectGraphMapper.model.GraphMappingResult;
import ai.stapi.graphoperations.objectGraphMapper.model.MissingFieldResolvingStrategy;
import ai.stapi.graphoperations.ogmProviders.specific.dynamicObjectGraphMappingProvider.DynamicOgmProvider;
import ai.stapi.graphsystem.aggregatedefinition.model.CommandHandlerDefinitionDTO;
import ai.stapi.graphsystem.aggregategraphstatemodifier.AbstractAggregateGraphStateModificator;
import ai.stapi.graphsystem.aggregategraphstatemodifier.exceptions.CannotUpsertToAggregateState;
import ai.stapi.graphsystem.messaging.command.DynamicCommand;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.List;
import java.util.Map;

public class UpsertAggregateGraphStateModificator
extends AbstractAggregateGraphStateModificator {
    public UpsertAggregateGraphStateModificator(StructureSchemaFinder structureSchemaFinder, DynamicOgmProvider dynamicOgmProvider, GenericObjectGraphMapper objectGraphMapper) {
        super(structureSchemaFinder, dynamicOgmProvider, objectGraphMapper);
    }

    @Override
    public GraphMappingResult modify(String aggregateType, Graph currentAggregateState, DynamicCommand command, CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationStructureType, MissingFieldResolvingStrategy missingFieldResolvingStrategy) {
        Object mainNodeId = command.getTargetIdentifier();
        String inputValueParameterName = modificationDefinition.getInputValueParameterName();
        if (inputValueParameterName == null) {
            throw CannotUpsertToAggregateState.becauseModificationDefinitionDoesNotHaveInputValueParameterNameSpecified(modificationDefinition, operationStructureType, mainNodeId);
        }
        Object inputValue = command.getData().get(inputValueParameterName);
        if (inputValue == null) {
            return new GraphMappingResult(new Graph(), List.of());
        }
        InMemoryGraphRepository aggregateRepo = currentAggregateState.traversable();
        if (!aggregateRepo.nodeExists(mainNodeId, aggregateType)) {
            throw CannotUpsertToAggregateState.becauseMainAggregateNodeDoesntExist(operationStructureType, modificationDefinition, mainNodeId);
        }
        TraversableNode traversingStartNode = this.getTraversingStartNode(aggregateType, command, modificationDefinition, operationStructureType, aggregateRepo);
        String modificationPath = modificationDefinition.getModificationPath();
        String[] splitPath = modificationPath.split("\\.");
        TraversableNode modifiedNode = this.traverseToModifiedNode(traversingStartNode, splitPath, List.of(), operationStructureType, modificationDefinition);
        FieldDefinition inputValueSchema = operationStructureType.getField(inputValueParameterName);
        String fieldName = splitPath[splitPath.length - 1];
        ObjectGraphMapping objectOgm = this.getOgm(modifiedNode, inputValueSchema, fieldName);
        Map<String, Object> fakedObject = this.getMappedObject(inputValue, modifiedNode, fieldName);
        return this.objectGraphMapper.mapToGraph(objectOgm, fakedObject, missingFieldResolvingStrategy);
    }

    @Override
    public boolean supports(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition) {
        return modificationDefinition.getKind().equals("upsert");
    }
}

