/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.aggregategraphstatemodifier.exceptions;

import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphsystem.aggregatedefinition.model.CommandHandlerDefinitionDTO;
import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CannotAddToAggregateState
extends RuntimeException {
    private CannotAddToAggregateState(String becauseMessage) {
        super("Cannot add to aggregate state, because " + becauseMessage);
    }

    public CannotAddToAggregateState(List<CannotAddToAggregateState> cannotAddToAggregateStateList) {
        super(cannotAddToAggregateStateList.stream().map(Throwable::getMessage).collect(Collectors.joining("\n")));
    }

    public static CannotAddToAggregateState becauseModificationPathIsInvalid(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationDefinition) {
        return new CannotAddToAggregateState(String.format("modification path present in modification definition was invalid.%nOperation name: '%s'%nModification kind: '%s'%nModification path: '%s'", operationDefinition.getDefinitionType(), modificationDefinition.getKind(), modificationDefinition.getModificationPath()));
    }

    public static CannotAddToAggregateState becauseModificationPathDoesNotStartWithCorrectAggregateType(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationDefinition, String actualAggregateType) {
        return new CannotAddToAggregateState(String.format("modification path does not start with correct aggregate type.%nOperation name: '%s'%nModification kind: '%s'%nModification path: '%s'%nActual aggregate type: '%s'", operationDefinition.getDefinitionType(), modificationDefinition.getKind(), modificationDefinition.getModificationPath(), actualAggregateType));
    }

    public static CannotAddToAggregateState becauseModificationPathContainsFieldNameNotPresentInSchema(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationDefinition) {
        return new CannotAddToAggregateState(String.format("modification path present in modification definition contains field name not present in schema.%nOperation name: '%s'%nModification kind: '%s'%nModification path: '%s'", operationDefinition.getDefinitionType(), modificationDefinition.getKind(), modificationDefinition.getModificationPath()));
    }

    public static CannotAddToAggregateState becauseModificationPathContainsFieldNameWhichIsPrimitiveButItShouldNot(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationDefinition) {
        return new CannotAddToAggregateState(String.format("modification path present in modification definition contains field name which is of primitive type, but it is not end of path.%nOperation name: '%s'%nModification kind: '%s'%nModification path: '%s'", operationDefinition.getDefinitionType(), modificationDefinition.getKind(), modificationDefinition.getModificationPath()));
    }

    public static CannotAddToAggregateState becauseModificationDefinitionDoesNotHaveInputValueParameterNameSpecified(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationDefinition) {
        return new CannotAddToAggregateState(String.format("modification definition does not have input value parameter name specified.%nOperation name: '%s'%nModification kind: '%s'%nModification path: '%s'", operationDefinition.getDefinitionType(), modificationDefinition.getKind(), modificationDefinition.getModificationPath()));
    }

    public static CannotAddToAggregateState becauseModifiedNodeSpecifiedByModificationPathWasNotPresent(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationDefinition) {
        String modificationPath = modificationDefinition.getModificationPath();
        String[] split = modificationPath.split("\\.");
        return new CannotAddToAggregateState(String.format("node to be modified (specified by modification path) was not present in aggregate state.%nOperation name: '%s'%nModification kind: '%s'%nExpected present parent node path: %s%nWhole Modification path: '%s'", operationDefinition.getDefinitionType(), modificationDefinition.getKind(), String.join((CharSequence)".", Arrays.copyOfRange(split, 0, split.length - 1)), modificationPath));
    }

    public static CannotAddToAggregateState becauseThereAreIndistinguishableNodes(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationDefinition, String expectedIdSourcePath) {
        return new CannotAddToAggregateState(String.format("modification definition has path which leads through list. %s%n%s%nOperation name: '%s'%nModification kind: '%s'%nModification path: '%s'", "But there is no id to distinguish between the items.", String.format("Maybe invalid command handler definition? You can fix this by adding parameter of type id to operation definition with source path: '%s'.", expectedIdSourcePath), operationDefinition.getDefinitionType(), modificationDefinition.getKind(), modificationDefinition.getModificationPath()));
    }

    public static CannotAddToAggregateState becauseThereAreMoreWaysToDistinguisNodes(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationStructureType, String sourcePathOfId) {
        return new CannotAddToAggregateState(String.format("modification definition has path which leads through multiple nodes. %s%nOperation name: '%s'%nModification kind: '%s'%nModification path: '%s'", String.format("But there are multiple parameters on operation definition with source path: '%s'.", sourcePathOfId), operationStructureType.getDefinitionType(), modificationDefinition.getKind(), modificationDefinition.getModificationPath()));
    }

    public static CannotAddToAggregateState becauseThereIsNoNodeWithIdSpecifiedAtSourcePath(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationStructureType, String sourcePathOfId, UniqueIdentifier id) {
        return new CannotAddToAggregateState(String.format("there is no node with id specified at source path.%nOperation name: '%s'%nNode path: '%s'%nId: '%s'%nModification kind: '%s'%nModification path: '%s'", operationStructureType.getDefinitionType(), sourcePathOfId, id.getId(), modificationDefinition.getKind(), modificationDefinition.getModificationPath()));
    }

    public static CannotAddToAggregateState becauseThereIsNoSourcePathAtStartIdParameterName(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationStructureType, UniqueIdentifier id, String startIdParameterName) {
        return new CannotAddToAggregateState(String.format("there is no node with source path specified at start id parameter name.%nOperation name: '%s'%nId: '%s'%nModification kind: '%s'%nStart id parameter name: '%s'", operationStructureType.getDefinitionType(), id.getId(), modificationDefinition.getKind(), startIdParameterName));
    }

    public static CannotAddToAggregateState becauseThereAlreadyIsSuchLeafComplexType(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationStructureType, TraversableNode modifiedNode) {
        return new CannotAddToAggregateState(String.format("there already is such singular complex type, but add operation cannot modify existing data. Use command with upsert modification instead.%nOperation name: '%s'%nModification kind: '%s'%nModification path: '%s'%nModified node identifier: '%s/%s'", operationStructureType.getDefinitionType(), modificationDefinition.getKind(), modificationDefinition.getModificationPath(), modifiedNode.getType(), modifiedNode.getId().getId()));
    }

    public static CannotAddToAggregateState becauseThereAlreadyIsSuchLeafAttribute(CommandHandlerDefinitionDTO.EventFactory.EventFactoryModification modificationDefinition, ComplexStructureType operationStructureType, TraversableNode modifiedNode) {
        return new CannotAddToAggregateState(String.format("there already is such leaf attribute, but add operation cannot modify existing data. Use command with upsert modification instead.%nOperation name: '%s'%nModification kind: '%s'%nModification path: '%s'%nModified node identifier: '%s/%s'", operationStructureType.getDefinitionType(), modificationDefinition.getKind(), modificationDefinition.getModificationPath(), modifiedNode.getType(), modifiedNode.getId().getId()));
    }
}

