/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.operationdefinition.model;

import ai.stapi.graphsystem.operationdefinition.exceptions.CannotMapOperationDefinitionToStructureType;
import ai.stapi.graphsystem.operationdefinition.model.FieldDefinitionWithSource;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchema.PrimitiveStructureType;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaProvider;
import ai.stapi.schema.structureSchemaProvider.exception.CannotProvideStructureSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OperationDefinitionStructureTypeMapper {
    private final StructureSchemaProvider structureSchemaProvider;

    public OperationDefinitionStructureTypeMapper(StructureSchemaProvider structureSchemaProvider) {
        this.structureSchemaProvider = structureSchemaProvider;
    }

    public List<ComplexStructureType> map(List<OperationDefinitionDTO> operationDefinitions) {
        return operationDefinitions.stream().map(this::map).toList();
    }

    public ComplexStructureType map(OperationDefinitionDTO operationDefinition) {
        String operationName = operationDefinition.getId();
        Map<ParameterGroupIdentifier, List<OperationDefinitionDTO.ParameterDTO>> parameterGroups = this.createParameterGroups(operationDefinition);
        HashMap fakeFields = new HashMap();
        parameterGroups.forEach((parameterGroupIdentifier, parameters) -> {
            OperationDefinitionDTO.ParameterDTO anyParameter = (OperationDefinitionDTO.ParameterDTO)parameters.get(0);
            String finalFieldName = parameters.size() == 1 ? anyParameter.getName() : parameterGroupIdentifier.fieldName();
            FieldDefinitionWithSource fakeField = new FieldDefinitionWithSource(finalFieldName, anyParameter.getMin(), anyParameter.getMax(), "", parameters.stream().flatMap(parameter -> this.fakeFieldType(operationName, (OperationDefinitionDTO.ParameterDTO)parameter, parameters.size() > 1)).toList(), operationName, anyParameter.getSingleReferencedFrom().getSource());
            fakeFields.put(finalFieldName, fakeField);
        });
        return new ComplexStructureType(operationName, fakeFields, operationDefinition.getDescription(), null, false);
    }

    private Map<ParameterGroupIdentifier, List<OperationDefinitionDTO.ParameterDTO>> createParameterGroups(OperationDefinitionDTO operationDefinition) {
        HashMap<ParameterGroupIdentifier, List<OperationDefinitionDTO.ParameterDTO>> parameterGroups = new HashMap<ParameterGroupIdentifier, List<OperationDefinitionDTO.ParameterDTO>>();
        operationDefinition.getParameter().forEach(parameter -> {
            if (!parameter.getUse().equals("in")) {
                return;
            }
            String parameterName = parameter.getName();
            String fieldName = this.createFieldName(parameterName, StringUtils.capitalize((String)parameter.getType()));
            List<OperationDefinitionDTO.ParameterDTO.ReferencedFrom> referencedFrom = parameter.getReferencedFrom();
            String source = referencedFrom.size() > 0 ? referencedFrom.get(0).getSource() : null;
            ParameterGroupIdentifier key = new ParameterGroupIdentifier(fieldName, source);
            List parameters = parameterGroups.getOrDefault(key, new ArrayList());
            parameters.add(parameter);
            parameterGroups.put(key, parameters);
        });
        return parameterGroups;
    }

    private String createFieldName(String parameterName, String parameterType) {
        int suffixLength = parameterType.length();
        if (parameterName.length() < suffixLength + 1) {
            return parameterName;
        }
        if (parameterName.equals(parameterType)) {
            return parameterName;
        }
        if (!parameterName.endsWith(parameterType)) {
            return parameterName;
        }
        return parameterName.substring(0, parameterName.length() - suffixLength);
    }

    @NotNull
    private Stream<FieldType> fakeFieldType(String operationName, OperationDefinitionDTO.ParameterDTO parameterDTO, boolean isInUnion) {
        AbstractStructureType structure;
        String type = parameterDTO.getType();
        if (type.equals("Reference")) {
            return parameterDTO.getTargetProfileRef().stream().map((? super T targetProfile) -> new FieldType(targetProfile.getId(), type));
        }
        try {
            structure = this.structureSchemaProvider.provideSpecific(type);
        }
        catch (CannotProvideStructureSchema exception) {
            throw new CannotMapOperationDefinitionToStructureType(operationName, parameterDTO.getName(), type, exception);
        }
        if (structure instanceof PrimitiveStructureType && isInUnion) {
            return Stream.of(new FieldType(String.format("Boxed%s", StringUtils.capitalize((String)type)), type));
        }
        return Stream.of(new FieldType(type, type));
    }

    private record ParameterGroupIdentifier(String fieldName, @Nullable String referencedFrom) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParameterGroupIdentifier)) {
                return false;
            }
            ParameterGroupIdentifier that = (ParameterGroupIdentifier)o;
            if (!this.fieldName().equals(that.fieldName())) {
                return false;
            }
            return this.referencedFrom() != null ? this.referencedFrom().equals(that.referencedFrom()) : that.referencedFrom() == null;
        }

        @Override
        public int hashCode() {
            int result = this.fieldName().hashCode();
            result = 31 * result + (this.referencedFrom() != null ? this.referencedFrom().hashCode() : 0);
            return result;
        }
    }
}

