/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.aggregatedefinition.model.eventFactory;

import ai.stapi.graphsystem.aggregatedefinition.model.AggregateDefinitionDTO;
import ai.stapi.graphsystem.aggregatedefinition.model.AggregateDefinitionProvider;
import ai.stapi.graphsystem.aggregatedefinition.model.CommandHandlerDefinitionDTO;
import ai.stapi.graphsystem.aggregatedefinition.model.EventFactoryModification;
import ai.stapi.graphsystem.aggregatedefinition.model.eventFactory.EventFactoryModificationResult;
import ai.stapi.graphsystem.aggregatedefinition.model.eventFactory.OperationEventFactoriesMapper;
import ai.stapi.graphsystem.eventdefinition.EventMessageDefinitionData;
import ai.stapi.graphsystem.operationdefinition.model.FieldDefinitionWithSource;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionStructureTypeMapper;
import ai.stapi.graphsystem.operationdefinition.model.resourceStructureTypeOperationsMapper.OperationDefinitionParameters;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structuredefinition.StructureDefinitionId;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class CreatedOperationEventFactoriesMapper
implements OperationEventFactoriesMapper {
    private final OperationDefinitionStructureTypeMapper mapper;
    private final AggregateDefinitionProvider aggregateDefinitionProvider;

    public CreatedOperationEventFactoriesMapper(OperationDefinitionStructureTypeMapper mapper, AggregateDefinitionProvider aggregateDefinitionProvider) {
        this.mapper = mapper;
        this.aggregateDefinitionProvider = aggregateDefinitionProvider;
    }

    @Override
    public List<CommandHandlerDefinitionDTO.EventFactory> map(OperationDefinitionDTO operationDefinition) {
        String resourceName = operationDefinition.getResource().get(0);
        String createdEventId = this.createCreatedEventId(resourceName);
        String createdEventName = this.createCreatedEventName(resourceName);
        ComplexStructureType fakedStructure = this.mapper.map(operationDefinition);
        Optional<CommandHandlerDefinitionDTO.EventFactory> eventFactory = this.getEventFactory(operationDefinition.getId());
        return List.of(new CommandHandlerDefinitionDTO.EventFactory(eventFactory.isPresent() ? eventFactory.get().getId() : UUID.randomUUID().toString(), new EventMessageDefinitionData(createdEventId, createdEventName, new StructureDefinitionId(resourceName), "Generated Event for newly created " + resourceName + "."), fakedStructure.getAllFields().values().stream().map((? super T param) -> this.createModification(param.getName(), param.getName())).toList()));
    }

    @Override
    public List<EventFactoryModificationResult> mapParameters(OperationDefinitionParameters operationDefinitionParameters) {
        String operationId = operationDefinitionParameters.getOperationId();
        Optional<CommandHandlerDefinitionDTO.EventFactory> eventFactory = this.getEventFactory(operationId);
        ComplexStructureType fakedStructure = this.mapper.map(OperationDefinitionDTO.bareBone(operationId, operationDefinitionParameters.getParameters()));
        return List.of(new EventFactoryModificationResult(eventFactory.isPresent() ? eventFactory.get().getId() : UUID.randomUUID().toString(), fakedStructure.getAllFields().values().stream().map(FieldDefinitionWithSource.class::cast).map((? super T param) -> this.createModification(param.getName(), param.getName())).toList()));
    }

    private Optional<CommandHandlerDefinitionDTO.EventFactory> getEventFactory(String operationId) {
        List<CommandHandlerDefinitionDTO.EventFactory> eventFactories;
        if (!this.aggregateDefinitionProvider.containsAggregateForOperation(operationId)) {
            return Optional.empty();
        }
        AggregateDefinitionDTO aggregate = this.aggregateDefinitionProvider.getAggregateForOperation(operationId);
        Optional<CommandHandlerDefinitionDTO> commandHandler = aggregate.getCommand().stream().filter(command -> command.getOperation().getId().equals(operationId)).findFirst();
        if (commandHandler.isPresent() && !(eventFactories = commandHandler.get().getEventFactory()).isEmpty()) {
            return Optional.of(eventFactories.get(0));
        }
        return Optional.empty();
    }

    private EventFactoryModification createModification(String modificationPath, String parameterName) {
        return EventFactoryModification.add(modificationPath, null, parameterName);
    }

    private String createCreatedEventId(String resourceName) {
        return resourceName + "Created";
    }

    private String createCreatedEventName(String resourceName) {
        return resourceName + " Created";
    }
}

