/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.aggregategraphstatemodifier;

import ai.stapi.graph.AttributeContainer;
import ai.stapi.graph.Graph;
import ai.stapi.graph.graphelements.Node;
import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphMapper.model.GenericObjectGraphMapper;
import ai.stapi.graphoperations.objectGraphMapper.model.GraphMappingResult;
import ai.stapi.graphoperations.objectGraphMapper.model.MissingFieldResolvingStrategy;
import ai.stapi.graphsystem.aggregatedefinition.model.EventFactoryModification;
import ai.stapi.graphsystem.aggregategraphstatemodifier.AbstractAggregateGraphStateModificator;
import ai.stapi.graphsystem.aggregategraphstatemodifier.EventFactoryModificationTraverser;
import ai.stapi.graphsystem.aggregategraphstatemodifier.EventModificatorOgmProvider;
import ai.stapi.graphsystem.aggregategraphstatemodifier.exceptions.CannotAddToAggregateState;
import ai.stapi.graphsystem.messaging.command.DynamicCommand;
import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import java.util.List;
import java.util.Map;

public class AddAggregateGraphStateModificator
extends AbstractAggregateGraphStateModificator {
    public AddAggregateGraphStateModificator(GenericObjectGraphMapper objectGraphMapper, EventFactoryModificationTraverser eventFactoryModificationTraverser, EventModificatorOgmProvider eventModificatorOgmProvider) {
        super(objectGraphMapper, eventFactoryModificationTraverser, eventModificatorOgmProvider);
    }

    @Override
    public GraphMappingResult modify(String aggregateType, Graph currentAggregateState, DynamicCommand command, EventFactoryModification modificationDefinition, ComplexStructureType operationStructureType, MissingFieldResolvingStrategy missingFieldResolvingStrategy) {
        String inputValueParameterName = modificationDefinition.getInputValueParameterName();
        if (inputValueParameterName == null) {
            throw CannotAddToAggregateState.becauseModificationDefinitionDoesNotHaveInputValueParameterNameSpecified(modificationDefinition, operationStructureType);
        }
        Object inputValue = command.getData().get(inputValueParameterName);
        if (inputValue == null) {
            return new GraphMappingResult(new Graph(new AttributeContainer[]{new Node(command.getTargetIdentifier(), aggregateType)}), List.of());
        }
        InMemoryGraphRepository aggregateRepo = currentAggregateState.traversable();
        TraversableNode traversingStartNode = this.eventFactoryModificationTraverser.getTraversingStartNode(aggregateType, (UniqueIdentifier)command.getTargetIdentifier(), command.getData(), modificationDefinition, operationStructureType, aggregateRepo);
        String modificationPath = modificationDefinition.getModificationPath();
        String[] splitPath = modificationPath.split("\\.");
        TraversableNode modifiedNode = this.eventFactoryModificationTraverser.traverseToModifiedNode(traversingStartNode, splitPath, operationStructureType, modificationDefinition);
        FieldDefinition inputValueSchema = operationStructureType.getField(inputValueParameterName);
        String fieldName = splitPath[splitPath.length - 1];
        if (inputValueSchema.getFloatMax().floatValue() < 2.0f) {
            if (!modifiedNode.getEdges(fieldName).isEmpty()) {
                throw CannotAddToAggregateState.becauseThereAlreadyIsSuchLeafComplexType(modificationDefinition, operationStructureType, modifiedNode);
            }
            if (modifiedNode.hasAttribute(fieldName)) {
                throw CannotAddToAggregateState.becauseThereAlreadyIsSuchLeafAttribute(modificationDefinition, operationStructureType, modifiedNode);
            }
        }
        ObjectGraphMapping objectOgm = this.eventModificatorOgmProvider.getOgm(modifiedNode, inputValueSchema, fieldName);
        Map<String, Object> fakedObject = this.getMappedObject(inputValue, modifiedNode, fieldName);
        return this.objectGraphMapper.mapToGraph(objectOgm, fakedObject, missingFieldResolvingStrategy);
    }

    @Override
    public boolean supports(EventFactoryModification modificationDefinition) {
        return modificationDefinition.getKind().equals("add");
    }
}

