/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.aggregategraphstatemodifier;

import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.GraphDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.UuidIdentityDescription;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.GenericOGMBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.SpecificObjectGraphMappingBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.ObjectFieldDefinitionBuilder;
import ai.stapi.graphoperations.objectGraphLanguage.objectGraphMappingBuilder.specific.ogm.ObjectGraphMappingBuilder;
import ai.stapi.graphoperations.ogmProviders.specific.dynamicObjectGraphMappingProvider.DynamicOgmProvider;
import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import org.jetbrains.annotations.NotNull;

public class EventModificatorOgmProvider {
    protected final StructureSchemaFinder structureSchemaFinder;
    protected final DynamicOgmProvider dynamicOgmProvider;

    public EventModificatorOgmProvider(StructureSchemaFinder structureSchemaFinder, DynamicOgmProvider dynamicOgmProvider) {
        this.structureSchemaFinder = structureSchemaFinder;
        this.dynamicOgmProvider = dynamicOgmProvider;
    }

    @NotNull
    public ObjectGraphMapping getOgm(TraversableNode modifiedNode, FieldDefinition inputValueSchema, String fieldName) {
        ObjectGraphMappingBuilder objectOgm = new ObjectGraphMappingBuilder().setGraphDescription(new GraphDescriptionBuilder().addNodeDescription(modifiedNode.getType()));
        objectOgm.addField("id").addLeafAsObjectFieldMapping().setGraphDescription((GraphDescription)new UuidIdentityDescription());
        ObjectFieldDefinitionBuilder dataField = objectOgm.addField(fieldName);
        GraphDescriptionBuilder edge = new GraphDescriptionBuilder().addOutgoingEdge(fieldName);
        if (inputValueSchema.isUnionType()) {
            if (inputValueSchema.isList()) {
                dataField.addListAsObjectFieldMapping().addInterfaceChildDefinition().setGraphDescription(edge);
            } else {
                dataField.setRelation(edge).addInterfaceAsObjectFieldMapping();
            }
        } else {
            String type = ((FieldType)inputValueSchema.getTypes().get(0)).getType();
            AbstractStructureType inputValueType = this.structureSchemaFinder.getStructureType(type);
            if (inputValueType instanceof ComplexStructureType) {
                ObjectGraphMapping inputOgm = this.dynamicOgmProvider.provideGraphMapping(type);
                SpecificObjectGraphMappingBuilder inputOgmBuilder = new GenericOGMBuilder().copyGraphMappingAsBuilder(inputOgm);
                if (inputValueSchema.isList()) {
                    dataField.addListAsObjectFieldMapping().setGraphDescription(edge).setChildDefinition(inputOgmBuilder);
                } else {
                    dataField.setRelation(edge).setOgmBuilder(inputOgmBuilder);
                }
            } else {
                ObjectGraphMapping primitiveOgm = this.dynamicOgmProvider.provideOgmForPrimitive(type, new FieldDefinition(fieldName, inputValueSchema.getMin(), inputValueSchema.getMax(), inputValueSchema.getDescription(), inputValueSchema.getTypes(), inputValueSchema.getParentDefinitionType()));
                SpecificObjectGraphMappingBuilder primitiveOgmBuilder = new GenericOGMBuilder().copyGraphMappingAsBuilder(primitiveOgm);
                dataField.setOgmBuilder(primitiveOgmBuilder);
            }
        }
        return objectOgm.build();
    }
}

