/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphsystem.operationdefinition.infrastructure;

import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.EdgeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.UuidIdentityDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.AttributeQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.GraphElementQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.NodeQueryGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.OutgoingEdgeQueryDescription;
import ai.stapi.graphoperations.graphLoader.GraphLoader;
import ai.stapi.graphoperations.graphLoader.GraphLoaderReturnType;
import ai.stapi.graphoperations.graphLoader.search.SearchQueryParameters;
import ai.stapi.graphoperations.graphLoader.search.paginationOption.OffsetPaginationOption;
import ai.stapi.graphoperations.graphLoader.search.paginationOption.PaginationOption;
import ai.stapi.graphsystem.operationdefinition.exceptions.CannotProvideOperationDefinition;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionProvider;
import java.util.ArrayList;
import java.util.List;

public class DatabaseOperationDefinitionProvider
implements OperationDefinitionProvider {
    private final GraphLoader graphLoader;
    private List<OperationDefinitionDTO> cachedOperations;

    public DatabaseOperationDefinitionProvider(GraphLoader graphLoader) {
        this.graphLoader = graphLoader;
        this.cachedOperations = new ArrayList<OperationDefinitionDTO>();
    }

    @Override
    public List<OperationDefinitionDTO> provideAll() {
        this.cacheOperations();
        return this.cachedOperations;
    }

    @Override
    public OperationDefinitionDTO provide(String operationId) throws CannotProvideOperationDefinition {
        this.cacheOperations();
        return this.cachedOperations.stream().filter(operation -> operation.getId().equals(operationId)).findFirst().orElseThrow(() -> new CannotProvideOperationDefinition(operationId));
    }

    @Override
    public boolean contains(String operationId) {
        this.cacheOperations();
        return this.cachedOperations.stream().anyMatch(operation -> operation.getId().equals(operationId));
    }

    private void cacheOperations() {
        if (this.cachedOperations.isEmpty()) {
            this.cachedOperations = this.graphLoader.find((GraphElementQueryDescription)this.getOperationGraphDescription(), OperationDefinitionDTO.class, new GraphLoaderReturnType[0]).getData();
        }
    }

    public NodeQueryGraphDescription getOperationGraphDescription() {
        return new NodeQueryGraphDescription(new NodeDescriptionParameters("OperationDefinition"), SearchQueryParameters.builder().setPaginationOption((PaginationOption)new OffsetPaginationOption(Integer.valueOf(0), Integer.valueOf(50000))).build(), new GraphDescription[]{new UuidIdentityDescription(), new AttributeQueryDescription("name"), new AttributeQueryDescription("status"), new AttributeQueryDescription("kind"), new AttributeQueryDescription("description"), new AttributeQueryDescription("code"), new AttributeQueryDescription("resource"), new AttributeQueryDescription("system"), new AttributeQueryDescription("type"), new AttributeQueryDescription("instance"), new OutgoingEdgeQueryDescription(new EdgeDescriptionParameters("parameter"), SearchQueryParameters.builder().setPaginationOption((PaginationOption)new OffsetPaginationOption(Integer.valueOf(0), Integer.valueOf(300))).build(), new GraphDescription[]{new NodeDescription(new NodeDescriptionParameters("OperationDefinitionParameter"), new GraphDescription[]{new AttributeQueryDescription("name"), new AttributeQueryDescription("use"), new AttributeQueryDescription("min"), new AttributeQueryDescription("max"), new AttributeQueryDescription("type"), new OutgoingEdgeQueryDescription(new EdgeDescriptionParameters("referencedFrom"), SearchQueryParameters.builder().setPaginationOption((PaginationOption)new OffsetPaginationOption(Integer.valueOf(0), Integer.valueOf(300))).build(), new GraphDescription[]{new NodeDescription(new NodeDescriptionParameters("OperationDefinitionParameterReferencedFrom"), new GraphDescription[]{new AttributeQueryDescription("source")})}), new OutgoingEdgeQueryDescription(new EdgeDescriptionParameters("targetProfile"), SearchQueryParameters.builder().setPaginationOption((PaginationOption)new OffsetPaginationOption(Integer.valueOf(0), Integer.valueOf(300))).build(), new GraphDescription[]{new NodeDescription(new NodeDescriptionParameters("StructureDefinition"), new GraphDescription[]{new UuidIdentityDescription()})})})})});
    }
}

