/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graph.attribute.attributeFactory.attributeValueFactory;

import ai.stapi.graph.attribute.attributeFactory.attributeValueFactory.AttributeValueFactory;
import ai.stapi.graph.attribute.attributeFactory.exceptions.CannotCreateAttribute;
import ai.stapi.graph.attribute.attributeValue.AttributeValue;
import ai.stapi.graph.attribute.attributeValue.DecimalAttributeValue;
import org.apache.commons.lang3.math.NumberUtils;

public class DecimalValueFactory
implements AttributeValueFactory {
    @Override
    public AttributeValue<?> create(Object value, String attributeName) {
        if (!this.isValidValue(value)) {
            throw CannotCreateAttribute.becauseProvidedValueCouldNotBeConvertedToProvidedDataType(attributeName, "decimal", value);
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return new DecimalAttributeValue(floatValue.doubleValue());
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return new DecimalAttributeValue(doubleValue);
        }
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return new DecimalAttributeValue(integerValue.doubleValue());
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return new DecimalAttributeValue(NumberUtils.createDouble((String)stringValue));
        }
        throw CannotCreateAttribute.becauseProvidedValueCouldNotBeConvertedToProvidedDataType(attributeName, "decimal", value);
    }

    @Override
    public boolean supportsDataType(String dataType) {
        return dataType.equals("decimal");
    }

    @Override
    public boolean isValidValue(Object value) {
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return true;
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return true;
        }
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return true;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return NumberUtils.isParsable((String)stringValue);
        }
        return false;
    }
}

